/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The App Runner resource that specifies an App Runner endpoint for incoming traffic. It establishes a connection
 * between a VPC interface endpoint and a App Runner service, to make your App Runner service accessible from only
 * within an Amazon VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcIngressConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcIngressConnection.Builder, VpcIngressConnection> {
    private static final SdkField<String> VPC_INGRESS_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcIngressConnectionArn").getter(getter(VpcIngressConnection::vpcIngressConnectionArn))
            .setter(setter(Builder::vpcIngressConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionArn").build())
            .build();

    private static final SdkField<String> VPC_INGRESS_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcIngressConnectionName").getter(getter(VpcIngressConnection::vpcIngressConnectionName))
            .setter(setter(Builder::vpcIngressConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionName").build())
            .build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(VpcIngressConnection::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(VpcIngressConnection::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(VpcIngressConnection::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(VpcIngressConnection::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<IngressVpcConfiguration> INGRESS_VPC_CONFIGURATION_FIELD = SdkField
            .<IngressVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("IngressVpcConfiguration")
            .getter(getter(VpcIngressConnection::ingressVpcConfiguration)).setter(setter(Builder::ingressVpcConfiguration))
            .constructor(IngressVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressVpcConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(VpcIngressConnection::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletedAt").getter(getter(VpcIngressConnection::deletedAt)).setter(setter(Builder::deletedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_INGRESS_CONNECTION_ARN_FIELD, VPC_INGRESS_CONNECTION_NAME_FIELD, SERVICE_ARN_FIELD, STATUS_FIELD,
            ACCOUNT_ID_FIELD, DOMAIN_NAME_FIELD, INGRESS_VPC_CONFIGURATION_FIELD, CREATED_AT_FIELD, DELETED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcIngressConnectionArn;

    private final String vpcIngressConnectionName;

    private final String serviceArn;

    private final String status;

    private final String accountId;

    private final String domainName;

    private final IngressVpcConfiguration ingressVpcConfiguration;

    private final Instant createdAt;

    private final Instant deletedAt;

    private VpcIngressConnection(BuilderImpl builder) {
        this.vpcIngressConnectionArn = builder.vpcIngressConnectionArn;
        this.vpcIngressConnectionName = builder.vpcIngressConnectionName;
        this.serviceArn = builder.serviceArn;
        this.status = builder.status;
        this.accountId = builder.accountId;
        this.domainName = builder.domainName;
        this.ingressVpcConfiguration = builder.ingressVpcConfiguration;
        this.createdAt = builder.createdAt;
        this.deletedAt = builder.deletedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the VPC Ingress Connection.
     */
    public final String vpcIngressConnectionArn() {
        return vpcIngressConnectionArn;
    }

    /**
     * <p>
     * The customer-provided VPC Ingress Connection name.
     * </p>
     * 
     * @return The customer-provided VPC Ingress Connection name.
     */
    public final String vpcIngressConnectionName() {
        return vpcIngressConnectionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the following
     * statuses: <code>AVAILABLE</code>, <code>PENDING_CREATION</code>, <code>PENDING_UPDATE</code>,
     * <code>PENDING_DELETION</code>,<code>FAILED_CREATION</code>, <code>FAILED_UPDATE</code>,
     * <code>FAILED_DELETION</code>, and <code>DELETED</code>..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VpcIngressConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the
     *         following statuses: <code>AVAILABLE</code>, <code>PENDING_CREATION</code>, <code>PENDING_UPDATE</code>,
     *         <code>PENDING_DELETION</code>,<code>FAILED_CREATION</code>, <code>FAILED_UPDATE</code>,
     *         <code>FAILED_DELETION</code>, and <code>DELETED</code>..
     * @see VpcIngressConnectionStatus
     */
    public final VpcIngressConnectionStatus status() {
        return VpcIngressConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the following
     * statuses: <code>AVAILABLE</code>, <code>PENDING_CREATION</code>, <code>PENDING_UPDATE</code>,
     * <code>PENDING_DELETION</code>,<code>FAILED_CREATION</code>, <code>FAILED_UPDATE</code>,
     * <code>FAILED_DELETION</code>, and <code>DELETED</code>..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VpcIngressConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the
     *         following statuses: <code>AVAILABLE</code>, <code>PENDING_CREATION</code>, <code>PENDING_UPDATE</code>,
     *         <code>PENDING_DELETION</code>,<code>FAILED_CREATION</code>, <code>FAILED_UPDATE</code>,
     *         <code>FAILED_DELETION</code>, and <code>DELETED</code>..
     * @see VpcIngressConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Account Id you use to create the VPC Ingress Connection resource.
     * </p>
     * 
     * @return The Account Id you use to create the VPC Ingress Connection resource.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The domain name associated with the VPC Ingress Connection resource.
     * </p>
     * 
     * @return The domain name associated with the VPC Ingress Connection resource.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Specifications for the customer’s VPC and related PrivateLink VPC endpoint that are used to associate with the
     * VPC Ingress Connection resource.
     * </p>
     * 
     * @return Specifications for the customer’s VPC and related PrivateLink VPC endpoint that are used to associate
     *         with the VPC Ingress Connection resource.
     */
    public final IngressVpcConfiguration ingressVpcConfiguration() {
        return ingressVpcConfiguration;
    }

    /**
     * <p>
     * The time when the VPC Ingress Connection was created. It's in the Unix time stamp format.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Type: Timestamp
     * </p>
     * </li>
     * <li>
     * <p>
     * Required: Yes
     * </p>
     * </li>
     * </ul>
     * 
     * @return The time when the VPC Ingress Connection was created. It's in the Unix time stamp format.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Type: Timestamp
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Required: Yes
     *         </p>
     *         </li>
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time when the App Runner service was deleted. It's in the Unix time stamp format.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Type: Timestamp
     * </p>
     * </li>
     * <li>
     * <p>
     * Required: No
     * </p>
     * </li>
     * </ul>
     * 
     * @return The time when the App Runner service was deleted. It's in the Unix time stamp format.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Type: Timestamp
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Required: No
     *         </p>
     *         </li>
     */
    public final Instant deletedAt() {
        return deletedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcIngressConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcIngressConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(ingressVpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deletedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcIngressConnection)) {
            return false;
        }
        VpcIngressConnection other = (VpcIngressConnection) obj;
        return Objects.equals(vpcIngressConnectionArn(), other.vpcIngressConnectionArn())
                && Objects.equals(vpcIngressConnectionName(), other.vpcIngressConnectionName())
                && Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(ingressVpcConfiguration(), other.ingressVpcConfiguration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(deletedAt(), other.deletedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcIngressConnection").add("VpcIngressConnectionArn", vpcIngressConnectionArn())
                .add("VpcIngressConnectionName", vpcIngressConnectionName()).add("ServiceArn", serviceArn())
                .add("Status", statusAsString()).add("AccountId", accountId()).add("DomainName", domainName())
                .add("IngressVpcConfiguration", ingressVpcConfiguration()).add("CreatedAt", createdAt())
                .add("DeletedAt", deletedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcIngressConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcIngressConnectionArn()));
        case "VpcIngressConnectionName":
            return Optional.ofNullable(clazz.cast(vpcIngressConnectionName()));
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "IngressVpcConfiguration":
            return Optional.ofNullable(clazz.cast(ingressVpcConfiguration()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DeletedAt":
            return Optional.ofNullable(clazz.cast(deletedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcIngressConnectionArn", VPC_INGRESS_CONNECTION_ARN_FIELD);
        map.put("VpcIngressConnectionName", VPC_INGRESS_CONNECTION_NAME_FIELD);
        map.put("ServiceArn", SERVICE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("IngressVpcConfiguration", INGRESS_VPC_CONFIGURATION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DeletedAt", DELETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcIngressConnection, T> g) {
        return obj -> g.apply((VpcIngressConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcIngressConnection> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
         * </p>
         * 
         * @param vpcIngressConnectionArn
         *        The Amazon Resource Name (ARN) of the VPC Ingress Connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIngressConnectionArn(String vpcIngressConnectionArn);

        /**
         * <p>
         * The customer-provided VPC Ingress Connection name.
         * </p>
         * 
         * @param vpcIngressConnectionName
         *        The customer-provided VPC Ingress Connection name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIngressConnectionName(String vpcIngressConnectionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the following
         * statuses: <code>AVAILABLE</code>, <code>PENDING_CREATION</code>, <code>PENDING_UPDATE</code>,
         * <code>PENDING_DELETION</code>,<code>FAILED_CREATION</code>, <code>FAILED_UPDATE</code>,
         * <code>FAILED_DELETION</code>, and <code>DELETED</code>..
         * </p>
         * 
         * @param status
         *        The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the
         *        following statuses: <code>AVAILABLE</code>, <code>PENDING_CREATION</code>, <code>PENDING_UPDATE</code>
         *        , <code>PENDING_DELETION</code>,<code>FAILED_CREATION</code>, <code>FAILED_UPDATE</code>,
         *        <code>FAILED_DELETION</code>, and <code>DELETED</code>..
         * @see VpcIngressConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcIngressConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the following
         * statuses: <code>AVAILABLE</code>, <code>PENDING_CREATION</code>, <code>PENDING_UPDATE</code>,
         * <code>PENDING_DELETION</code>,<code>FAILED_CREATION</code>, <code>FAILED_UPDATE</code>,
         * <code>FAILED_DELETION</code>, and <code>DELETED</code>..
         * </p>
         * 
         * @param status
         *        The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the
         *        following statuses: <code>AVAILABLE</code>, <code>PENDING_CREATION</code>, <code>PENDING_UPDATE</code>
         *        , <code>PENDING_DELETION</code>,<code>FAILED_CREATION</code>, <code>FAILED_UPDATE</code>,
         *        <code>FAILED_DELETION</code>, and <code>DELETED</code>..
         * @see VpcIngressConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcIngressConnectionStatus
         */
        Builder status(VpcIngressConnectionStatus status);

        /**
         * <p>
         * The Account Id you use to create the VPC Ingress Connection resource.
         * </p>
         * 
         * @param accountId
         *        The Account Id you use to create the VPC Ingress Connection resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The domain name associated with the VPC Ingress Connection resource.
         * </p>
         * 
         * @param domainName
         *        The domain name associated with the VPC Ingress Connection resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Specifications for the customer’s VPC and related PrivateLink VPC endpoint that are used to associate with
         * the VPC Ingress Connection resource.
         * </p>
         * 
         * @param ingressVpcConfiguration
         *        Specifications for the customer’s VPC and related PrivateLink VPC endpoint that are used to associate
         *        with the VPC Ingress Connection resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration);

        /**
         * <p>
         * Specifications for the customer’s VPC and related PrivateLink VPC endpoint that are used to associate with
         * the VPC Ingress Connection resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressVpcConfiguration.Builder} avoiding
         * the need to create one manually via {@link IngressVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ingressVpcConfiguration(IngressVpcConfiguration)}.
         * 
         * @param ingressVpcConfiguration
         *        a consumer that will call methods on {@link IngressVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressVpcConfiguration(IngressVpcConfiguration)
         */
        default Builder ingressVpcConfiguration(Consumer<IngressVpcConfiguration.Builder> ingressVpcConfiguration) {
            return ingressVpcConfiguration(IngressVpcConfiguration.builder().applyMutation(ingressVpcConfiguration).build());
        }

        /**
         * <p>
         * The time when the VPC Ingress Connection was created. It's in the Unix time stamp format.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Type: Timestamp
         * </p>
         * </li>
         * <li>
         * <p>
         * Required: Yes
         * </p>
         * </li>
         * </ul>
         * 
         * @param createdAt
         *        The time when the VPC Ingress Connection was created. It's in the Unix time stamp format.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Type: Timestamp
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Required: Yes
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time when the App Runner service was deleted. It's in the Unix time stamp format.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Type: Timestamp
         * </p>
         * </li>
         * <li>
         * <p>
         * Required: No
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletedAt
         *        The time when the App Runner service was deleted. It's in the Unix time stamp format.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Type: Timestamp
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Required: No
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedAt(Instant deletedAt);
    }

    static final class BuilderImpl implements Builder {
        private String vpcIngressConnectionArn;

        private String vpcIngressConnectionName;

        private String serviceArn;

        private String status;

        private String accountId;

        private String domainName;

        private IngressVpcConfiguration ingressVpcConfiguration;

        private Instant createdAt;

        private Instant deletedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcIngressConnection model) {
            vpcIngressConnectionArn(model.vpcIngressConnectionArn);
            vpcIngressConnectionName(model.vpcIngressConnectionName);
            serviceArn(model.serviceArn);
            status(model.status);
            accountId(model.accountId);
            domainName(model.domainName);
            ingressVpcConfiguration(model.ingressVpcConfiguration);
            createdAt(model.createdAt);
            deletedAt(model.deletedAt);
        }

        public final String getVpcIngressConnectionArn() {
            return vpcIngressConnectionArn;
        }

        public final void setVpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
        }

        @Override
        public final Builder vpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            return this;
        }

        public final String getVpcIngressConnectionName() {
            return vpcIngressConnectionName;
        }

        public final void setVpcIngressConnectionName(String vpcIngressConnectionName) {
            this.vpcIngressConnectionName = vpcIngressConnectionName;
        }

        @Override
        public final Builder vpcIngressConnectionName(String vpcIngressConnectionName) {
            this.vpcIngressConnectionName = vpcIngressConnectionName;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VpcIngressConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final IngressVpcConfiguration.Builder getIngressVpcConfiguration() {
            return ingressVpcConfiguration != null ? ingressVpcConfiguration.toBuilder() : null;
        }

        public final void setIngressVpcConfiguration(IngressVpcConfiguration.BuilderImpl ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration != null ? ingressVpcConfiguration.build() : null;
        }

        @Override
        public final Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        @Override
        public VpcIngressConnection build() {
            return new VpcIngressConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
