/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateObservabilityConfigurationRequest extends AppRunnerRequest implements
        ToCopyableBuilder<CreateObservabilityConfigurationRequest.Builder, CreateObservabilityConfigurationRequest> {
    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObservabilityConfigurationName")
            .getter(getter(CreateObservabilityConfigurationRequest::observabilityConfigurationName))
            .setter(setter(Builder::observabilityConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationName")
                    .build()).build();

    private static final SdkField<TraceConfiguration> TRACE_CONFIGURATION_FIELD = SdkField
            .<TraceConfiguration> builder(MarshallingType.SDK_POJO).memberName("TraceConfiguration")
            .getter(getter(CreateObservabilityConfigurationRequest::traceConfiguration))
            .setter(setter(Builder::traceConfiguration)).constructor(TraceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateObservabilityConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OBSERVABILITY_CONFIGURATION_NAME_FIELD, TRACE_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String observabilityConfigurationName;

    private final TraceConfiguration traceConfiguration;

    private final List<Tag> tags;

    private CreateObservabilityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.observabilityConfigurationName = builder.observabilityConfigurationName;
        this.traceConfiguration = builder.traceConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the observability configuration. When you use it for the first time in an Amazon Web Services Region,
     * App Runner creates revision number <code>1</code> of this name. When you use the same name in subsequent calls,
     * App Runner creates incremental revisions of the configuration.
     * </p>
     * <note>
     * <p>
     * The name <code>DefaultConfiguration</code> is reserved. You can't use it to create a new observability
     * configuration, and you can't create a revision of it.
     * </p>
     * <p>
     * When you want to use your own observability configuration for your App Runner service, <i>create a configuration
     * with a different name</i>, and then provide it when you create or update your service.
     * </p>
     * </note>
     * 
     * @return A name for the observability configuration. When you use it for the first time in an Amazon Web Services
     *         Region, App Runner creates revision number <code>1</code> of this name. When you use the same name in
     *         subsequent calls, App Runner creates incremental revisions of the configuration.</p> <note>
     *         <p>
     *         The name <code>DefaultConfiguration</code> is reserved. You can't use it to create a new observability
     *         configuration, and you can't create a revision of it.
     *         </p>
     *         <p>
     *         When you want to use your own observability configuration for your App Runner service, <i>create a
     *         configuration with a different name</i>, and then provide it when you create or update your service.
     *         </p>
     */
    public final String observabilityConfigurationName() {
        return observabilityConfigurationName;
    }

    /**
     * <p>
     * The configuration of the tracing feature within this observability configuration. If you don't specify it, App
     * Runner doesn't enable tracing.
     * </p>
     * 
     * @return The configuration of the tracing feature within this observability configuration. If you don't specify
     *         it, App Runner doesn't enable tracing.
     */
    public final TraceConfiguration traceConfiguration() {
        return traceConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metadata items that you can associate with your observability configuration resource. A tag is a
     * key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of metadata items that you can associate with your observability configuration resource. A tag is
     *         a key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(traceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateObservabilityConfigurationRequest)) {
            return false;
        }
        CreateObservabilityConfigurationRequest other = (CreateObservabilityConfigurationRequest) obj;
        return Objects.equals(observabilityConfigurationName(), other.observabilityConfigurationName())
                && Objects.equals(traceConfiguration(), other.traceConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateObservabilityConfigurationRequest")
                .add("ObservabilityConfigurationName", observabilityConfigurationName())
                .add("TraceConfiguration", traceConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObservabilityConfigurationName":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationName()));
        case "TraceConfiguration":
            return Optional.ofNullable(clazz.cast(traceConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObservabilityConfigurationName", OBSERVABILITY_CONFIGURATION_NAME_FIELD);
        map.put("TraceConfiguration", TRACE_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateObservabilityConfigurationRequest, T> g) {
        return obj -> g.apply((CreateObservabilityConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateObservabilityConfigurationRequest> {
        /**
         * <p>
         * A name for the observability configuration. When you use it for the first time in an Amazon Web Services
         * Region, App Runner creates revision number <code>1</code> of this name. When you use the same name in
         * subsequent calls, App Runner creates incremental revisions of the configuration.
         * </p>
         * <note>
         * <p>
         * The name <code>DefaultConfiguration</code> is reserved. You can't use it to create a new observability
         * configuration, and you can't create a revision of it.
         * </p>
         * <p>
         * When you want to use your own observability configuration for your App Runner service, <i>create a
         * configuration with a different name</i>, and then provide it when you create or update your service.
         * </p>
         * </note>
         * 
         * @param observabilityConfigurationName
         *        A name for the observability configuration. When you use it for the first time in an Amazon Web
         *        Services Region, App Runner creates revision number <code>1</code> of this name. When you use the same
         *        name in subsequent calls, App Runner creates incremental revisions of the configuration.</p> <note>
         *        <p>
         *        The name <code>DefaultConfiguration</code> is reserved. You can't use it to create a new observability
         *        configuration, and you can't create a revision of it.
         *        </p>
         *        <p>
         *        When you want to use your own observability configuration for your App Runner service, <i>create a
         *        configuration with a different name</i>, and then provide it when you create or update your service.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationName(String observabilityConfigurationName);

        /**
         * <p>
         * The configuration of the tracing feature within this observability configuration. If you don't specify it,
         * App Runner doesn't enable tracing.
         * </p>
         * 
         * @param traceConfiguration
         *        The configuration of the tracing feature within this observability configuration. If you don't specify
         *        it, App Runner doesn't enable tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceConfiguration(TraceConfiguration traceConfiguration);

        /**
         * <p>
         * The configuration of the tracing feature within this observability configuration. If you don't specify it,
         * App Runner doesn't enable tracing.
         * </p>
         * This is a convenience method that creates an instance of the {@link TraceConfiguration.Builder} avoiding the
         * need to create one manually via {@link TraceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TraceConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #traceConfiguration(TraceConfiguration)}.
         * 
         * @param traceConfiguration
         *        a consumer that will call methods on {@link TraceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traceConfiguration(TraceConfiguration)
         */
        default Builder traceConfiguration(Consumer<TraceConfiguration.Builder> traceConfiguration) {
            return traceConfiguration(TraceConfiguration.builder().applyMutation(traceConfiguration).build());
        }

        /**
         * <p>
         * A list of metadata items that you can associate with your observability configuration resource. A tag is a
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of metadata items that you can associate with your observability configuration resource. A tag
         *        is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of metadata items that you can associate with your observability configuration resource. A tag is a
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of metadata items that you can associate with your observability configuration resource. A tag
         *        is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of metadata items that you can associate with your observability configuration resource. A tag is a
         * key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apprunner.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String observabilityConfigurationName;

        private TraceConfiguration traceConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateObservabilityConfigurationRequest model) {
            super(model);
            observabilityConfigurationName(model.observabilityConfigurationName);
            traceConfiguration(model.traceConfiguration);
            tags(model.tags);
        }

        public final String getObservabilityConfigurationName() {
            return observabilityConfigurationName;
        }

        public final void setObservabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
        }

        @Override
        public final Builder observabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
            return this;
        }

        public final TraceConfiguration.Builder getTraceConfiguration() {
            return traceConfiguration != null ? traceConfiguration.toBuilder() : null;
        }

        public final void setTraceConfiguration(TraceConfiguration.BuilderImpl traceConfiguration) {
            this.traceConfiguration = traceConfiguration != null ? traceConfiguration.build() : null;
        }

        @Override
        public final Builder traceConfiguration(TraceConfiguration traceConfiguration) {
            this.traceConfiguration = traceConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateObservabilityConfigurationRequest build() {
            return new CreateObservabilityConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
