/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcIngressConnectionRequest extends AppRunnerRequest implements
        ToCopyableBuilder<CreateVpcIngressConnectionRequest.Builder, CreateVpcIngressConnectionRequest> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(CreateVpcIngressConnectionRequest::serviceArn))
            .setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<String> VPC_INGRESS_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcIngressConnectionName").getter(getter(CreateVpcIngressConnectionRequest::vpcIngressConnectionName))
            .setter(setter(Builder::vpcIngressConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionName").build())
            .build();

    private static final SdkField<IngressVpcConfiguration> INGRESS_VPC_CONFIGURATION_FIELD = SdkField
            .<IngressVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("IngressVpcConfiguration")
            .getter(getter(CreateVpcIngressConnectionRequest::ingressVpcConfiguration))
            .setter(setter(Builder::ingressVpcConfiguration)).constructor(IngressVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressVpcConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateVpcIngressConnectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD,
            VPC_INGRESS_CONNECTION_NAME_FIELD, INGRESS_VPC_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceArn;

    private final String vpcIngressConnectionName;

    private final IngressVpcConfiguration ingressVpcConfiguration;

    private final List<Tag> tags;

    private CreateVpcIngressConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.serviceArn = builder.serviceArn;
        this.vpcIngressConnectionName = builder.vpcIngressConnectionName;
        this.ingressVpcConfiguration = builder.ingressVpcConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this App Runner service that is used to create the VPC Ingress Connection
     * resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for this App Runner service that is used to create the VPC Ingress
     *         Connection resource.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * A name for the VPC Ingress Connection resource. It must be unique across all the active VPC Ingress Connections
     * in your Amazon Web Services account in the Amazon Web Services Region.
     * </p>
     * 
     * @return A name for the VPC Ingress Connection resource. It must be unique across all the active VPC Ingress
     *         Connections in your Amazon Web Services account in the Amazon Web Services Region.
     */
    public final String vpcIngressConnectionName() {
        return vpcIngressConnectionName;
    }

    /**
     * <p>
     * Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC endpoint that
     * are used to create the VPC Ingress Connection resource.
     * </p>
     * 
     * @return Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC endpoint
     *         that are used to create the VPC Ingress Connection resource.
     */
    public final IngressVpcConfiguration ingressVpcConfiguration() {
        return ingressVpcConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag is a
     * key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag
     *         is a key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcIngressConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(ingressVpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcIngressConnectionRequest)) {
            return false;
        }
        CreateVpcIngressConnectionRequest other = (CreateVpcIngressConnectionRequest) obj;
        return Objects.equals(serviceArn(), other.serviceArn())
                && Objects.equals(vpcIngressConnectionName(), other.vpcIngressConnectionName())
                && Objects.equals(ingressVpcConfiguration(), other.ingressVpcConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcIngressConnectionRequest").add("ServiceArn", serviceArn())
                .add("VpcIngressConnectionName", vpcIngressConnectionName())
                .add("IngressVpcConfiguration", ingressVpcConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "VpcIngressConnectionName":
            return Optional.ofNullable(clazz.cast(vpcIngressConnectionName()));
        case "IngressVpcConfiguration":
            return Optional.ofNullable(clazz.cast(ingressVpcConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceArn", SERVICE_ARN_FIELD);
        map.put("VpcIngressConnectionName", VPC_INGRESS_CONNECTION_NAME_FIELD);
        map.put("IngressVpcConfiguration", INGRESS_VPC_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcIngressConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpcIngressConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcIngressConnectionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for this App Runner service that is used to create the VPC Ingress Connection
         * resource.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) for this App Runner service that is used to create the VPC Ingress
         *        Connection resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * A name for the VPC Ingress Connection resource. It must be unique across all the active VPC Ingress
         * Connections in your Amazon Web Services account in the Amazon Web Services Region.
         * </p>
         * 
         * @param vpcIngressConnectionName
         *        A name for the VPC Ingress Connection resource. It must be unique across all the active VPC Ingress
         *        Connections in your Amazon Web Services account in the Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIngressConnectionName(String vpcIngressConnectionName);

        /**
         * <p>
         * Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC endpoint
         * that are used to create the VPC Ingress Connection resource.
         * </p>
         * 
         * @param ingressVpcConfiguration
         *        Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC
         *        endpoint that are used to create the VPC Ingress Connection resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration);

        /**
         * <p>
         * Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC endpoint
         * that are used to create the VPC Ingress Connection resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressVpcConfiguration.Builder} avoiding
         * the need to create one manually via {@link IngressVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ingressVpcConfiguration(IngressVpcConfiguration)}.
         * 
         * @param ingressVpcConfiguration
         *        a consumer that will call methods on {@link IngressVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressVpcConfiguration(IngressVpcConfiguration)
         */
        default Builder ingressVpcConfiguration(Consumer<IngressVpcConfiguration.Builder> ingressVpcConfiguration) {
            return ingressVpcConfiguration(IngressVpcConfiguration.builder().applyMutation(ingressVpcConfiguration).build());
        }

        /**
         * <p>
         * An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag is
         * a key-value pair.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A
         *        tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag is
         * a key-value pair.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A
         *        tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag is
         * a key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apprunner.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String serviceArn;

        private String vpcIngressConnectionName;

        private IngressVpcConfiguration ingressVpcConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcIngressConnectionRequest model) {
            super(model);
            serviceArn(model.serviceArn);
            vpcIngressConnectionName(model.vpcIngressConnectionName);
            ingressVpcConfiguration(model.ingressVpcConfiguration);
            tags(model.tags);
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getVpcIngressConnectionName() {
            return vpcIngressConnectionName;
        }

        public final void setVpcIngressConnectionName(String vpcIngressConnectionName) {
            this.vpcIngressConnectionName = vpcIngressConnectionName;
        }

        @Override
        public final Builder vpcIngressConnectionName(String vpcIngressConnectionName) {
            this.vpcIngressConnectionName = vpcIngressConnectionName;
            return this;
        }

        public final IngressVpcConfiguration.Builder getIngressVpcConfiguration() {
            return ingressVpcConfiguration != null ? ingressVpcConfiguration.toBuilder() : null;
        }

        public final void setIngressVpcConfiguration(IngressVpcConfiguration.BuilderImpl ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration != null ? ingressVpcConfiguration.build() : null;
        }

        @Override
        public final Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcIngressConnectionRequest build() {
            return new CreateVpcIngressConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
