/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes configuration settings related to network traffic of an App Runner service. Consists of embedded objects
 * for each configurable network feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConfiguration.Builder, NetworkConfiguration> {
    private static final SdkField<EgressConfiguration> EGRESS_CONFIGURATION_FIELD = SdkField
            .<EgressConfiguration> builder(MarshallingType.SDK_POJO).memberName("EgressConfiguration")
            .getter(getter(NetworkConfiguration::egressConfiguration)).setter(setter(Builder::egressConfiguration))
            .constructor(EgressConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressConfiguration").build())
            .build();

    private static final SdkField<IngressConfiguration> INGRESS_CONFIGURATION_FIELD = SdkField
            .<IngressConfiguration> builder(MarshallingType.SDK_POJO).memberName("IngressConfiguration")
            .getter(getter(NetworkConfiguration::ingressConfiguration)).setter(setter(Builder::ingressConfiguration))
            .constructor(IngressConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressConfiguration").build())
            .build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(NetworkConfiguration::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_CONFIGURATION_FIELD,
            INGRESS_CONFIGURATION_FIELD, IP_ADDRESS_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EgressConfiguration egressConfiguration;

    private final IngressConfiguration ingressConfiguration;

    private final String ipAddressType;

    private NetworkConfiguration(BuilderImpl builder) {
        this.egressConfiguration = builder.egressConfiguration;
        this.ingressConfiguration = builder.ingressConfiguration;
        this.ipAddressType = builder.ipAddressType;
    }

    /**
     * <p>
     * Network configuration settings for outbound message traffic.
     * </p>
     * 
     * @return Network configuration settings for outbound message traffic.
     */
    public final EgressConfiguration egressConfiguration() {
        return egressConfiguration;
    }

    /**
     * <p>
     * Network configuration settings for inbound message traffic.
     * </p>
     * 
     * @return Network configuration settings for inbound message traffic.
     */
    public final IngressConfiguration ingressConfiguration() {
        return ingressConfiguration;
    }

    /**
     * <p>
     * App Runner provides you with the option to choose between <i>Internet Protocol version 4 (IPv4)</i> and <i>dual
     * stack</i> (IPv4 and IPv6) for your incoming public network configuration. This is an optional parameter. If you
     * do not specify an <code>IpAddressType</code>, it defaults to select IPv4.
     * </p>
     * <note>
     * <p>
     * Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private endpoint.
     * If you update a service that's using dual-stack Public endpoint to a Private endpoint, your App Runner service
     * will default to support only IPv4 for Private endpoint and fail to receive traffic originating from IPv6
     * endpoint.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return App Runner provides you with the option to choose between <i>Internet Protocol version 4 (IPv4)</i> and
     *         <i>dual stack</i> (IPv4 and IPv6) for your incoming public network configuration. This is an optional
     *         parameter. If you do not specify an <code>IpAddressType</code>, it defaults to select IPv4.</p> <note>
     *         <p>
     *         Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private
     *         endpoint. If you update a service that's using dual-stack Public endpoint to a Private endpoint, your App
     *         Runner service will default to support only IPv4 for Private endpoint and fail to receive traffic
     *         originating from IPv6 endpoint.
     *         </p>
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * App Runner provides you with the option to choose between <i>Internet Protocol version 4 (IPv4)</i> and <i>dual
     * stack</i> (IPv4 and IPv6) for your incoming public network configuration. This is an optional parameter. If you
     * do not specify an <code>IpAddressType</code>, it defaults to select IPv4.
     * </p>
     * <note>
     * <p>
     * Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private endpoint.
     * If you update a service that's using dual-stack Public endpoint to a Private endpoint, your App Runner service
     * will default to support only IPv4 for Private endpoint and fail to receive traffic originating from IPv6
     * endpoint.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return App Runner provides you with the option to choose between <i>Internet Protocol version 4 (IPv4)</i> and
     *         <i>dual stack</i> (IPv4 and IPv6) for your incoming public network configuration. This is an optional
     *         parameter. If you do not specify an <code>IpAddressType</code>, it defaults to select IPv4.</p> <note>
     *         <p>
     *         Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private
     *         endpoint. If you update a service that's using dual-stack Public endpoint to a Private endpoint, your App
     *         Runner service will default to support only IPv4 for Private endpoint and fail to receive traffic
     *         originating from IPv6 endpoint.
     *         </p>
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(egressConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(ingressConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration) obj;
        return Objects.equals(egressConfiguration(), other.egressConfiguration())
                && Objects.equals(ingressConfiguration(), other.ingressConfiguration())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConfiguration").add("EgressConfiguration", egressConfiguration())
                .add("IngressConfiguration", ingressConfiguration()).add("IpAddressType", ipAddressTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressConfiguration":
            return Optional.ofNullable(clazz.cast(egressConfiguration()));
        case "IngressConfiguration":
            return Optional.ofNullable(clazz.cast(ingressConfiguration()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EgressConfiguration", EGRESS_CONFIGURATION_FIELD);
        map.put("IngressConfiguration", INGRESS_CONFIGURATION_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkConfiguration, T> g) {
        return obj -> g.apply((NetworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConfiguration> {
        /**
         * <p>
         * Network configuration settings for outbound message traffic.
         * </p>
         * 
         * @param egressConfiguration
         *        Network configuration settings for outbound message traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressConfiguration(EgressConfiguration egressConfiguration);

        /**
         * <p>
         * Network configuration settings for outbound message traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link EgressConfiguration.Builder} avoiding the
         * need to create one manually via {@link EgressConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EgressConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #egressConfiguration(EgressConfiguration)}.
         * 
         * @param egressConfiguration
         *        a consumer that will call methods on {@link EgressConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressConfiguration(EgressConfiguration)
         */
        default Builder egressConfiguration(Consumer<EgressConfiguration.Builder> egressConfiguration) {
            return egressConfiguration(EgressConfiguration.builder().applyMutation(egressConfiguration).build());
        }

        /**
         * <p>
         * Network configuration settings for inbound message traffic.
         * </p>
         * 
         * @param ingressConfiguration
         *        Network configuration settings for inbound message traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressConfiguration(IngressConfiguration ingressConfiguration);

        /**
         * <p>
         * Network configuration settings for inbound message traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressConfiguration.Builder} avoiding
         * the need to create one manually via {@link IngressConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #ingressConfiguration(IngressConfiguration)}.
         * 
         * @param ingressConfiguration
         *        a consumer that will call methods on {@link IngressConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressConfiguration(IngressConfiguration)
         */
        default Builder ingressConfiguration(Consumer<IngressConfiguration.Builder> ingressConfiguration) {
            return ingressConfiguration(IngressConfiguration.builder().applyMutation(ingressConfiguration).build());
        }

        /**
         * <p>
         * App Runner provides you with the option to choose between <i>Internet Protocol version 4 (IPv4)</i> and
         * <i>dual stack</i> (IPv4 and IPv6) for your incoming public network configuration. This is an optional
         * parameter. If you do not specify an <code>IpAddressType</code>, it defaults to select IPv4.
         * </p>
         * <note>
         * <p>
         * Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private
         * endpoint. If you update a service that's using dual-stack Public endpoint to a Private endpoint, your App
         * Runner service will default to support only IPv4 for Private endpoint and fail to receive traffic originating
         * from IPv6 endpoint.
         * </p>
         * </note>
         * 
         * @param ipAddressType
         *        App Runner provides you with the option to choose between <i>Internet Protocol version 4 (IPv4)</i>
         *        and <i>dual stack</i> (IPv4 and IPv6) for your incoming public network configuration. This is an
         *        optional parameter. If you do not specify an <code>IpAddressType</code>, it defaults to select
         *        IPv4.</p> <note>
         *        <p>
         *        Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private
         *        endpoint. If you update a service that's using dual-stack Public endpoint to a Private endpoint, your
         *        App Runner service will default to support only IPv4 for Private endpoint and fail to receive traffic
         *        originating from IPv6 endpoint.
         *        </p>
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * App Runner provides you with the option to choose between <i>Internet Protocol version 4 (IPv4)</i> and
         * <i>dual stack</i> (IPv4 and IPv6) for your incoming public network configuration. This is an optional
         * parameter. If you do not specify an <code>IpAddressType</code>, it defaults to select IPv4.
         * </p>
         * <note>
         * <p>
         * Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private
         * endpoint. If you update a service that's using dual-stack Public endpoint to a Private endpoint, your App
         * Runner service will default to support only IPv4 for Private endpoint and fail to receive traffic originating
         * from IPv6 endpoint.
         * </p>
         * </note>
         * 
         * @param ipAddressType
         *        App Runner provides you with the option to choose between <i>Internet Protocol version 4 (IPv4)</i>
         *        and <i>dual stack</i> (IPv4 and IPv6) for your incoming public network configuration. This is an
         *        optional parameter. If you do not specify an <code>IpAddressType</code>, it defaults to select
         *        IPv4.</p> <note>
         *        <p>
         *        Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private
         *        endpoint. If you update a service that's using dual-stack Public endpoint to a Private endpoint, your
         *        App Runner service will default to support only IPv4 for Private endpoint and fail to receive traffic
         *        originating from IPv6 endpoint.
         *        </p>
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);
    }

    static final class BuilderImpl implements Builder {
        private EgressConfiguration egressConfiguration;

        private IngressConfiguration ingressConfiguration;

        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfiguration model) {
            egressConfiguration(model.egressConfiguration);
            ingressConfiguration(model.ingressConfiguration);
            ipAddressType(model.ipAddressType);
        }

        public final EgressConfiguration.Builder getEgressConfiguration() {
            return egressConfiguration != null ? egressConfiguration.toBuilder() : null;
        }

        public final void setEgressConfiguration(EgressConfiguration.BuilderImpl egressConfiguration) {
            this.egressConfiguration = egressConfiguration != null ? egressConfiguration.build() : null;
        }

        @Override
        public final Builder egressConfiguration(EgressConfiguration egressConfiguration) {
            this.egressConfiguration = egressConfiguration;
            return this;
        }

        public final IngressConfiguration.Builder getIngressConfiguration() {
            return ingressConfiguration != null ? ingressConfiguration.toBuilder() : null;
        }

        public final void setIngressConfiguration(IngressConfiguration.BuilderImpl ingressConfiguration) {
            this.ingressConfiguration = ingressConfiguration != null ? ingressConfiguration.build() : null;
        }

        @Override
        public final Builder ingressConfiguration(IngressConfiguration ingressConfiguration) {
            this.ingressConfiguration = ingressConfiguration;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        @Override
        public NetworkConfiguration build() {
            return new NetworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
