/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an VPC Ingress Connection, which includes its VPC Ingress Connection ARN and its
 * associated Service ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcIngressConnectionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcIngressConnectionSummary.Builder, VpcIngressConnectionSummary> {
    private static final SdkField<String> VPC_INGRESS_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcIngressConnectionArn").getter(getter(VpcIngressConnectionSummary::vpcIngressConnectionArn))
            .setter(setter(Builder::vpcIngressConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionArn").build())
            .build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(VpcIngressConnectionSummary::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_INGRESS_CONNECTION_ARN_FIELD, SERVICE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcIngressConnectionArn;

    private final String serviceArn;

    private VpcIngressConnectionSummary(BuilderImpl builder) {
        this.vpcIngressConnectionArn = builder.vpcIngressConnectionArn;
        this.serviceArn = builder.serviceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the VPC Ingress Connection.
     */
    public final String vpcIngressConnectionArn() {
        return vpcIngressConnectionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcIngressConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcIngressConnectionSummary)) {
            return false;
        }
        VpcIngressConnectionSummary other = (VpcIngressConnectionSummary) obj;
        return Objects.equals(vpcIngressConnectionArn(), other.vpcIngressConnectionArn())
                && Objects.equals(serviceArn(), other.serviceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcIngressConnectionSummary").add("VpcIngressConnectionArn", vpcIngressConnectionArn())
                .add("ServiceArn", serviceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcIngressConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcIngressConnectionArn()));
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcIngressConnectionArn", VPC_INGRESS_CONNECTION_ARN_FIELD);
        map.put("ServiceArn", SERVICE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcIngressConnectionSummary, T> g) {
        return obj -> g.apply((VpcIngressConnectionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcIngressConnectionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
         * </p>
         * 
         * @param vpcIngressConnectionArn
         *        The Amazon Resource Name (ARN) of the VPC Ingress Connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIngressConnectionArn(String vpcIngressConnectionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);
    }

    static final class BuilderImpl implements Builder {
        private String vpcIngressConnectionArn;

        private String serviceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcIngressConnectionSummary model) {
            vpcIngressConnectionArn(model.vpcIngressConnectionArn);
            serviceArn(model.serviceArn);
        }

        public final String getVpcIngressConnectionArn() {
            return vpcIngressConnectionArn;
        }

        public final void setVpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
        }

        @Override
        public final Builder vpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        @Override
        public VpcIngressConnectionSummary build() {
            return new VpcIngressConnectionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
