/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceRequest extends AppRunnerRequest implements
        ToCopyableBuilder<CreateServiceRequest.Builder, CreateServiceRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(CreateServiceRequest::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("SourceConfiguration")
            .getter(getter(CreateServiceRequest::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build())
            .build();

    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField
            .<InstanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("InstanceConfiguration")
            .getter(getter(CreateServiceRequest::instanceConfiguration)).setter(setter(Builder::instanceConfiguration))
            .constructor(InstanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateServiceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(CreateServiceRequest::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<HealthCheckConfiguration> HEALTH_CHECK_CONFIGURATION_FIELD = SdkField
            .<HealthCheckConfiguration> builder(MarshallingType.SDK_POJO).memberName("HealthCheckConfiguration")
            .getter(getter(CreateServiceRequest::healthCheckConfiguration)).setter(setter(Builder::healthCheckConfiguration))
            .constructor(HealthCheckConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfiguration").build())
            .build();

    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingConfigurationArn")
            .getter(getter(CreateServiceRequest::autoScalingConfigurationArn))
            .setter(setter(Builder::autoScalingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn")
                    .build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(CreateServiceRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<ServiceObservabilityConfiguration> OBSERVABILITY_CONFIGURATION_FIELD = SdkField
            .<ServiceObservabilityConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ObservabilityConfiguration")
            .getter(getter(CreateServiceRequest::observabilityConfiguration))
            .setter(setter(Builder::observabilityConfiguration))
            .constructor(ServiceObservabilityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            SOURCE_CONFIGURATION_FIELD, INSTANCE_CONFIGURATION_FIELD, TAGS_FIELD, ENCRYPTION_CONFIGURATION_FIELD,
            HEALTH_CHECK_CONFIGURATION_FIELD, AUTO_SCALING_CONFIGURATION_ARN_FIELD, NETWORK_CONFIGURATION_FIELD,
            OBSERVABILITY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceName;

    private final SourceConfiguration sourceConfiguration;

    private final InstanceConfiguration instanceConfiguration;

    private final List<Tag> tags;

    private final EncryptionConfiguration encryptionConfiguration;

    private final HealthCheckConfiguration healthCheckConfiguration;

    private final String autoScalingConfigurationArn;

    private final NetworkConfiguration networkConfiguration;

    private final ServiceObservabilityConfiguration observabilityConfiguration;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.tags = builder.tags;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.healthCheckConfiguration = builder.healthCheckConfiguration;
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.observabilityConfiguration = builder.observabilityConfiguration;
    }

    /**
     * <p>
     * A name for the App Runner service. It must be unique across all the running App Runner services in your Amazon
     * Web Services account in the Amazon Web Services Region.
     * </p>
     * 
     * @return A name for the App Runner service. It must be unique across all the running App Runner services in your
     *         Amazon Web Services account in the Amazon Web Services Region.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The source to deploy to the App Runner service. It can be a code or an image repository.
     * </p>
     * 
     * @return The source to deploy to the App Runner service. It can be a code or an image repository.
     */
    public final SourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    /**
     * <p>
     * The runtime configuration of instances (scaling units) of your service.
     * </p>
     * 
     * @return The runtime configuration of instances (scaling units) of your service.
     */
    public final InstanceConfiguration instanceConfiguration() {
        return instanceConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of metadata items that you can associate with the App Runner service resource. A tag is a
     * key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of metadata items that you can associate with the App Runner service resource. A tag is
     *         a key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it
     * maintains and your service logs. By default, App Runner uses an Amazon Web Services managed key.
     * </p>
     * 
     * @return An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that
     *         it maintains and your service logs. By default, App Runner uses an Amazon Web Services managed key.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * The settings for the health check that App Runner performs to monitor the health of the App Runner service.
     * </p>
     * 
     * @return The settings for the health check that App Runner performs to monitor the health of the App Runner
     *         service.
     */
    public final HealthCheckConfiguration healthCheckConfiguration() {
        return healthCheckConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to
     * associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling
     * configuration.
     * </p>
     * <p>
     * Specify an ARN with a name and a revision number to associate that revision. For example:
     * <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3</code>
     * </p>
     * <p>
     * Specify just the name to associate the latest revision. For example:
     * <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to
     *         associate with your service. If not provided, App Runner associates the latest revision of a default auto
     *         scaling configuration.</p>
     *         <p>
     *         Specify an ARN with a name and a revision number to associate that revision. For example:
     *         <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3</code>
     *         </p>
     *         <p>
     *         Specify just the name to associate the latest revision. For example:
     *         <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability</code>
     */
    public final String autoScalingConfigurationArn() {
        return autoScalingConfigurationArn;
    }

    /**
     * <p>
     * Configuration settings related to network traffic of the web application that the App Runner service runs.
     * </p>
     * 
     * @return Configuration settings related to network traffic of the web application that the App Runner service
     *         runs.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The observability configuration of your service.
     * </p>
     * 
     * @return The observability configuration of your service.
     */
    public final ServiceObservabilityConfiguration observabilityConfiguration() {
        return observabilityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest) obj;
        return Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(sourceConfiguration(), other.sourceConfiguration())
                && Objects.equals(instanceConfiguration(), other.instanceConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(healthCheckConfiguration(), other.healthCheckConfiguration())
                && Objects.equals(autoScalingConfigurationArn(), other.autoScalingConfigurationArn())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(observabilityConfiguration(), other.observabilityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceRequest").add("ServiceName", serviceName())
                .add("SourceConfiguration", sourceConfiguration()).add("InstanceConfiguration", instanceConfiguration())
                .add("Tags", hasTags() ? tags() : null).add("EncryptionConfiguration", encryptionConfiguration())
                .add("HealthCheckConfiguration", healthCheckConfiguration())
                .add("AutoScalingConfigurationArn", autoScalingConfigurationArn())
                .add("NetworkConfiguration", networkConfiguration())
                .add("ObservabilityConfiguration", observabilityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "SourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        case "InstanceConfiguration":
            return Optional.ofNullable(clazz.cast(instanceConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "HealthCheckConfiguration":
            return Optional.ofNullable(clazz.cast(healthCheckConfiguration()));
        case "AutoScalingConfigurationArn":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationArn()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "ObservabilityConfiguration":
            return Optional.ofNullable(clazz.cast(observabilityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("SourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        map.put("InstanceConfiguration", INSTANCE_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("HealthCheckConfiguration", HEALTH_CHECK_CONFIGURATION_FIELD);
        map.put("AutoScalingConfigurationArn", AUTO_SCALING_CONFIGURATION_ARN_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("ObservabilityConfiguration", OBSERVABILITY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppRunnerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceRequest> {
        /**
         * <p>
         * A name for the App Runner service. It must be unique across all the running App Runner services in your
         * Amazon Web Services account in the Amazon Web Services Region.
         * </p>
         * 
         * @param serviceName
         *        A name for the App Runner service. It must be unique across all the running App Runner services in
         *        your Amazon Web Services account in the Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The source to deploy to the App Runner service. It can be a code or an image repository.
         * </p>
         * 
         * @param sourceConfiguration
         *        The source to deploy to the App Runner service. It can be a code or an image repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SourceConfiguration sourceConfiguration);

        /**
         * <p>
         * The source to deploy to the App Runner service. It can be a code or an image repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceConfiguration(SourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }

        /**
         * <p>
         * The runtime configuration of instances (scaling units) of your service.
         * </p>
         * 
         * @param instanceConfiguration
         *        The runtime configuration of instances (scaling units) of your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfiguration(InstanceConfiguration instanceConfiguration);

        /**
         * <p>
         * The runtime configuration of instances (scaling units) of your service.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceConfiguration.Builder} avoiding
         * the need to create one manually via {@link InstanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceConfiguration(InstanceConfiguration)}.
         * 
         * @param instanceConfiguration
         *        a consumer that will call methods on {@link InstanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConfiguration(InstanceConfiguration)
         */
        default Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return instanceConfiguration(InstanceConfiguration.builder().applyMutation(instanceConfiguration).build());
        }

        /**
         * <p>
         * An optional list of metadata items that you can associate with the App Runner service resource. A tag is a
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the App Runner service resource. A tag
         *        is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the App Runner service resource. A tag is a
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the App Runner service resource. A tag
         *        is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the App Runner service resource. A tag is a
         * key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apprunner.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apprunner.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it
         * maintains and your service logs. By default, App Runner uses an Amazon Web Services managed key.
         * </p>
         * 
         * @param encryptionConfiguration
         *        An optional custom encryption key that App Runner uses to encrypt the copy of your source repository
         *        that it maintains and your service logs. By default, App Runner uses an Amazon Web Services managed
         *        key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it
         * maintains and your service logs. By default, App Runner uses an Amazon Web Services managed key.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * The settings for the health check that App Runner performs to monitor the health of the App Runner service.
         * </p>
         * 
         * @param healthCheckConfiguration
         *        The settings for the health check that App Runner performs to monitor the health of the App Runner
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfiguration(HealthCheckConfiguration healthCheckConfiguration);

        /**
         * <p>
         * The settings for the health check that App Runner performs to monitor the health of the App Runner service.
         * </p>
         * This is a convenience method that creates an instance of the {@link HealthCheckConfiguration.Builder}
         * avoiding the need to create one manually via {@link HealthCheckConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HealthCheckConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #healthCheckConfiguration(HealthCheckConfiguration)}.
         * 
         * @param healthCheckConfiguration
         *        a consumer that will call methods on {@link HealthCheckConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfiguration(HealthCheckConfiguration)
         */
        default Builder healthCheckConfiguration(Consumer<HealthCheckConfiguration.Builder> healthCheckConfiguration) {
            return healthCheckConfiguration(HealthCheckConfiguration.builder().applyMutation(healthCheckConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to
         * associate with your service. If not provided, App Runner associates the latest revision of a default auto
         * scaling configuration.
         * </p>
         * <p>
         * Specify an ARN with a name and a revision number to associate that revision. For example:
         * <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3</code>
         * </p>
         * <p>
         * Specify just the name to associate the latest revision. For example:
         * <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability</code>
         * </p>
         * 
         * @param autoScalingConfigurationArn
         *        The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want
         *        to associate with your service. If not provided, App Runner associates the latest revision of a
         *        default auto scaling configuration.</p>
         *        <p>
         *        Specify an ARN with a name and a revision number to associate that revision. For example:
         *        <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3</code>
         *        </p>
         *        <p>
         *        Specify just the name to associate the latest revision. For example:
         *        <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationArn(String autoScalingConfigurationArn);

        /**
         * <p>
         * Configuration settings related to network traffic of the web application that the App Runner service runs.
         * </p>
         * 
         * @param networkConfiguration
         *        Configuration settings related to network traffic of the web application that the App Runner service
         *        runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * Configuration settings related to network traffic of the web application that the App Runner service runs.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The observability configuration of your service.
         * </p>
         * 
         * @param observabilityConfiguration
         *        The observability configuration of your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfiguration(ServiceObservabilityConfiguration observabilityConfiguration);

        /**
         * <p>
         * The observability configuration of your service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceObservabilityConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServiceObservabilityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceObservabilityConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #observabilityConfiguration(ServiceObservabilityConfiguration)}.
         * 
         * @param observabilityConfiguration
         *        a consumer that will call methods on {@link ServiceObservabilityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #observabilityConfiguration(ServiceObservabilityConfiguration)
         */
        default Builder observabilityConfiguration(Consumer<ServiceObservabilityConfiguration.Builder> observabilityConfiguration) {
            return observabilityConfiguration(ServiceObservabilityConfiguration.builder()
                    .applyMutation(observabilityConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String serviceName;

        private SourceConfiguration sourceConfiguration;

        private InstanceConfiguration instanceConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private EncryptionConfiguration encryptionConfiguration;

        private HealthCheckConfiguration healthCheckConfiguration;

        private String autoScalingConfigurationArn;

        private NetworkConfiguration networkConfiguration;

        private ServiceObservabilityConfiguration observabilityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            serviceName(model.serviceName);
            sourceConfiguration(model.sourceConfiguration);
            instanceConfiguration(model.instanceConfiguration);
            tags(model.tags);
            encryptionConfiguration(model.encryptionConfiguration);
            healthCheckConfiguration(model.healthCheckConfiguration);
            autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            networkConfiguration(model.networkConfiguration);
            observabilityConfiguration(model.observabilityConfiguration);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return instanceConfiguration != null ? instanceConfiguration.toBuilder() : null;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        @Override
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final HealthCheckConfiguration.Builder getHealthCheckConfiguration() {
            return healthCheckConfiguration != null ? healthCheckConfiguration.toBuilder() : null;
        }

        public final void setHealthCheckConfiguration(HealthCheckConfiguration.BuilderImpl healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration != null ? healthCheckConfiguration.build() : null;
        }

        @Override
        public final Builder healthCheckConfiguration(HealthCheckConfiguration healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration;
            return this;
        }

        public final String getAutoScalingConfigurationArn() {
            return autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final ServiceObservabilityConfiguration.Builder getObservabilityConfiguration() {
            return observabilityConfiguration != null ? observabilityConfiguration.toBuilder() : null;
        }

        public final void setObservabilityConfiguration(ServiceObservabilityConfiguration.BuilderImpl observabilityConfiguration) {
            this.observabilityConfiguration = observabilityConfiguration != null ? observabilityConfiguration.build() : null;
        }

        @Override
        public final Builder observabilityConfiguration(ServiceObservabilityConfiguration observabilityConfiguration) {
            this.observabilityConfiguration = observabilityConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
