/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Network configuration settings for inbound network traffic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IngressConfiguration.Builder, IngressConfiguration> {
    private static final SdkField<Boolean> IS_PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPubliclyAccessible").getter(getter(IngressConfiguration::isPubliclyAccessible))
            .setter(setter(Builder::isPubliclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPubliclyAccessible").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PUBLICLY_ACCESSIBLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isPubliclyAccessible;

    private IngressConfiguration(BuilderImpl builder) {
        this.isPubliclyAccessible = builder.isPubliclyAccessible;
    }

    /**
     * <p>
     * Specifies whether your App Runner service is publicly accessible. To make the service publicly accessible set it
     * to <code>True</code>. To make the service privately accessible, from only within an Amazon VPC set it to
     * <code>False</code>.
     * </p>
     * 
     * @return Specifies whether your App Runner service is publicly accessible. To make the service publicly accessible
     *         set it to <code>True</code>. To make the service privately accessible, from only within an Amazon VPC set
     *         it to <code>False</code>.
     */
    public final Boolean isPubliclyAccessible() {
        return isPubliclyAccessible;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isPubliclyAccessible());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressConfiguration)) {
            return false;
        }
        IngressConfiguration other = (IngressConfiguration) obj;
        return Objects.equals(isPubliclyAccessible(), other.isPubliclyAccessible());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressConfiguration").add("IsPubliclyAccessible", isPubliclyAccessible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsPubliclyAccessible":
            return Optional.ofNullable(clazz.cast(isPubliclyAccessible()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IsPubliclyAccessible", IS_PUBLICLY_ACCESSIBLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressConfiguration, T> g) {
        return obj -> g.apply((IngressConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressConfiguration> {
        /**
         * <p>
         * Specifies whether your App Runner service is publicly accessible. To make the service publicly accessible set
         * it to <code>True</code>. To make the service privately accessible, from only within an Amazon VPC set it to
         * <code>False</code>.
         * </p>
         * 
         * @param isPubliclyAccessible
         *        Specifies whether your App Runner service is publicly accessible. To make the service publicly
         *        accessible set it to <code>True</code>. To make the service privately accessible, from only within an
         *        Amazon VPC set it to <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPubliclyAccessible(Boolean isPubliclyAccessible);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isPubliclyAccessible;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressConfiguration model) {
            isPubliclyAccessible(model.isPubliclyAccessible);
        }

        public final Boolean getIsPubliclyAccessible() {
            return isPubliclyAccessible;
        }

        public final void setIsPubliclyAccessible(Boolean isPubliclyAccessible) {
            this.isPubliclyAccessible = isPubliclyAccessible;
        }

        @Override
        public final Builder isPubliclyAccessible(Boolean isPubliclyAccessible) {
            this.isPubliclyAccessible = isPubliclyAccessible;
            return this;
        }

        @Override
        public IngressConfiguration build() {
            return new IngressConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
