/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information for an operation that occurred on an App Runner service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OperationSummary.Builder, OperationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(OperationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(OperationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OperationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(OperationSummary::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt").getter(getter(OperationSummary::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndedAt").getter(getter(OperationSummary::endedAt)).setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(OperationSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            STATUS_FIELD, TARGET_ARN_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String status;

    private final String targetArn;

    private final Instant startedAt;

    private final Instant endedAt;

    private final Instant updatedAt;

    private OperationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.targetArn = builder.targetArn;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * A unique ID of this operation. It's unique in the scope of the App Runner service.
     * </p>
     * 
     * @return A unique ID of this operation. It's unique in the scope of the App Runner service.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of operation. It indicates a specific action that occured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of operation. It indicates a specific action that occured.
     * @see OperationType
     */
    public final OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * The type of operation. It indicates a specific action that occured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of operation. It indicates a specific action that occured.
     * @see OperationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The current state of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the operation.
     * @see OperationStatus
     */
    public final OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the operation.
     * @see OperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner service).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner
     *         service).
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The time when the operation started. It's in the Unix time stamp format.
     * </p>
     * 
     * @return The time when the operation started. It's in the Unix time stamp format.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time when the operation ended. It's in the Unix time stamp format.
     * </p>
     * 
     * @return The time when the operation ended. It's in the Unix time stamp format.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The time when the operation was last updated. It's in the Unix time stamp format.
     * </p>
     * 
     * @return The time when the operation was last updated. It's in the Unix time stamp format.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationSummary)) {
            return false;
        }
        OperationSummary other = (OperationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperationSummary").add("Id", id()).add("Type", typeAsString()).add("Status", statusAsString())
                .add("TargetArn", targetArn()).add("StartedAt", startedAt()).add("EndedAt", endedAt())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "EndedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TargetArn", TARGET_ARN_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OperationSummary, T> g) {
        return obj -> g.apply((OperationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperationSummary> {
        /**
         * <p>
         * A unique ID of this operation. It's unique in the scope of the App Runner service.
         * </p>
         * 
         * @param id
         *        A unique ID of this operation. It's unique in the scope of the App Runner service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of operation. It indicates a specific action that occured.
         * </p>
         * 
         * @param type
         *        The type of operation. It indicates a specific action that occured.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of operation. It indicates a specific action that occured.
         * </p>
         * 
         * @param type
         *        The type of operation. It indicates a specific action that occured.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The current state of the operation.
         * </p>
         * 
         * @param status
         *        The current state of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the operation.
         * </p>
         * 
         * @param status
         *        The current state of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner
         * service).
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner
         *        service).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The time when the operation started. It's in the Unix time stamp format.
         * </p>
         * 
         * @param startedAt
         *        The time when the operation started. It's in the Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The time when the operation ended. It's in the Unix time stamp format.
         * </p>
         * 
         * @param endedAt
         *        The time when the operation ended. It's in the Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The time when the operation was last updated. It's in the Unix time stamp format.
         * </p>
         * 
         * @param updatedAt
         *        The time when the operation was last updated. It's in the Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String status;

        private String targetArn;

        private Instant startedAt;

        private Instant endedAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationSummary model) {
            id(model.id);
            type(model.type);
            status(model.status);
            targetArn(model.targetArn);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            updatedAt(model.updatedAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public OperationSummary build() {
            return new OperationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
