/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcIngressConnectionResponse extends AppRunnerResponse implements
        ToCopyableBuilder<UpdateVpcIngressConnectionResponse.Builder, UpdateVpcIngressConnectionResponse> {
    private static final SdkField<VpcIngressConnection> VPC_INGRESS_CONNECTION_FIELD = SdkField
            .<VpcIngressConnection> builder(MarshallingType.SDK_POJO).memberName("VpcIngressConnection")
            .getter(getter(UpdateVpcIngressConnectionResponse::vpcIngressConnection))
            .setter(setter(Builder::vpcIngressConnection)).constructor(VpcIngressConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_INGRESS_CONNECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcIngressConnection vpcIngressConnection;

    private UpdateVpcIngressConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcIngressConnection = builder.vpcIngressConnection;
    }

    /**
     * <p>
     * A description of the App Runner VPC Ingress Connection resource that's updated by this request.
     * </p>
     * 
     * @return A description of the App Runner VPC Ingress Connection resource that's updated by this request.
     */
    public final VpcIngressConnection vpcIngressConnection() {
        return vpcIngressConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcIngressConnection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcIngressConnectionResponse)) {
            return false;
        }
        UpdateVpcIngressConnectionResponse other = (UpdateVpcIngressConnectionResponse) obj;
        return Objects.equals(vpcIngressConnection(), other.vpcIngressConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcIngressConnectionResponse").add("VpcIngressConnection", vpcIngressConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcIngressConnection":
            return Optional.ofNullable(clazz.cast(vpcIngressConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcIngressConnection", VPC_INGRESS_CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcIngressConnectionResponse, T> g) {
        return obj -> g.apply((UpdateVpcIngressConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppRunnerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateVpcIngressConnectionResponse> {
        /**
         * <p>
         * A description of the App Runner VPC Ingress Connection resource that's updated by this request.
         * </p>
         * 
         * @param vpcIngressConnection
         *        A description of the App Runner VPC Ingress Connection resource that's updated by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIngressConnection(VpcIngressConnection vpcIngressConnection);

        /**
         * <p>
         * A description of the App Runner VPC Ingress Connection resource that's updated by this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcIngressConnection.Builder} avoiding
         * the need to create one manually via {@link VpcIngressConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcIngressConnection.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcIngressConnection(VpcIngressConnection)}.
         * 
         * @param vpcIngressConnection
         *        a consumer that will call methods on {@link VpcIngressConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcIngressConnection(VpcIngressConnection)
         */
        default Builder vpcIngressConnection(Consumer<VpcIngressConnection.Builder> vpcIngressConnection) {
            return vpcIngressConnection(VpcIngressConnection.builder().applyMutation(vpcIngressConnection).build());
        }
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private VpcIngressConnection vpcIngressConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcIngressConnectionResponse model) {
            super(model);
            vpcIngressConnection(model.vpcIngressConnection);
        }

        public final VpcIngressConnection.Builder getVpcIngressConnection() {
            return vpcIngressConnection != null ? vpcIngressConnection.toBuilder() : null;
        }

        public final void setVpcIngressConnection(VpcIngressConnection.BuilderImpl vpcIngressConnection) {
            this.vpcIngressConnection = vpcIngressConnection != null ? vpcIngressConnection.build() : null;
        }

        @Override
        public final Builder vpcIngressConnection(VpcIngressConnection vpcIngressConnection) {
            this.vpcIngressConnection = vpcIngressConnection;
            return this;
        }

        @Override
        public UpdateVpcIngressConnectionResponse build() {
            return new UpdateVpcIngressConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
