/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFleetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeFleetsResponse.Builder, DescribeFleetsResponse> {
    private final List<Fleet> fleets;

    private final String nextToken;

    private DescribeFleetsResponse(BuilderImpl builder) {
        this.fleets = builder.fleets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of fleet details.
     * </p>
     * 
     * @return The list of fleet details.
     */
    public List<Fleet> fleets() {
        return fleets;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fleets() == null) ? 0 : fleets().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetsResponse)) {
            return false;
        }
        DescribeFleetsResponse other = (DescribeFleetsResponse) obj;
        if (other.fleets() == null ^ this.fleets() == null) {
            return false;
        }
        if (other.fleets() != null && !other.fleets().equals(this.fleets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (fleets() != null) {
            sb.append("Fleets: ").append(fleets()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeFleetsResponse> {
        /**
         * <p>
         * The list of fleet details.
         * </p>
         * 
         * @param fleets
         *        The list of fleet details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Collection<Fleet> fleets);

        /**
         * <p>
         * The list of fleet details.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFleets(java.util.Collection)} or {@link #withFleets(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param fleets
         *        The list of fleet details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Fleet... fleets);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Fleet> fleets;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetsResponse model) {
            setFleets(model.fleets);
            setNextToken(model.nextToken);
        }

        public final Collection<Fleet> getFleets() {
            return fleets;
        }

        @Override
        public final Builder fleets(Collection<Fleet> fleets) {
            this.fleets = FleetListCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Fleet... fleets) {
            if (this.fleets == null) {
                this.fleets = new ArrayList<>(fleets.length);
            }
            for (Fleet e : fleets) {
                this.fleets.add(e);
            }
            return this;
        }

        public final void setFleets(Collection<Fleet> fleets) {
            this.fleets = FleetListCopier.copy(fleets);
        }

        @SafeVarargs
        public final void setFleets(Fleet... fleets) {
            if (this.fleets == null) {
                this.fleets = new ArrayList<>(fleets.length);
            }
            for (Fleet e : fleets) {
                this.fleets.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetsResponse build() {
            return new DescribeFleetsResponse(this);
        }
    }
}
