/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.appstream.transform.FleetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Fleet implements StructuredPojo, ToCopyableBuilder<Fleet.Builder, Fleet> {
    private final String arn;

    private final String name;

    private final String displayName;

    private final String description;

    private final String imageName;

    private final String instanceType;

    private final ComputeCapacityStatus computeCapacityStatus;

    private final Integer maxUserDurationInSeconds;

    private final Integer disconnectTimeoutInSeconds;

    private final String state;

    private final VpcConfig vpcConfig;

    private final Date createdTime;

    private final List<FleetError> fleetErrors;

    private final Boolean enableDefaultInternetAccess;

    private Fleet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.imageName = builder.imageName;
        this.instanceType = builder.instanceType;
        this.computeCapacityStatus = builder.computeCapacityStatus;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.state = builder.state;
        this.vpcConfig = builder.vpcConfig;
        this.createdTime = builder.createdTime;
        this.fleetErrors = builder.fleetErrors;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
    }

    /**
     * <p>
     * The ARN for the fleet.
     * </p>
     * 
     * @return The ARN for the fleet.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name displayed to end users on the AppStream 2.0 portal.
     * </p>
     * 
     * @return The name displayed to end users on the AppStream 2.0 portal.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description displayed to end users on the AppStream 2.0 portal.
     * </p>
     * 
     * @return The description displayed to end users on the AppStream 2.0 portal.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The image used by the fleet.
     * </p>
     * 
     * @return The image used by the fleet.
     */
    public String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The instance type of compute resources for the fleet. The fleet instances are launched from this instance type.
     * </p>
     * 
     * @return The instance type of compute resources for the fleet. The fleet instances are launched from this instance
     *         type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The capacity information for the fleet.
     * </p>
     * 
     * @return The capacity information for the fleet.
     */
    public ComputeCapacityStatus computeCapacityStatus() {
        return computeCapacityStatus;
    }

    /**
     * <p>
     * The maximum time for which a streaming session can run. The value can be any numeric value in seconds between 600
     * and 57600.
     * </p>
     * 
     * @return The maximum time for which a streaming session can run. The value can be any numeric value in seconds
     *         between 600 and 57600.
     */
    public Integer maxUserDurationInSeconds() {
        return maxUserDurationInSeconds;
    }

    /**
     * <p>
     * The time after disconnection when a session is considered to have ended. If a user who got disconnected
     * reconnects within this timeout interval, the user is connected back to their previous session. The input can be
     * any numeric value in seconds between 60 and 57600.
     * </p>
     * 
     * @return The time after disconnection when a session is considered to have ended. If a user who got disconnected
     *         reconnects within this timeout interval, the user is connected back to their previous session. The input
     *         can be any numeric value in seconds between 60 and 57600.
     */
    public Integer disconnectTimeoutInSeconds() {
        return disconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * The current state for the fleet.
     * </p>
     * 
     * @return The current state for the fleet.
     * @see FleetState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The VPC configuration for the fleet.
     * </p>
     * 
     * @return The VPC configuration for the fleet.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The time at which the fleet was created.
     * </p>
     * 
     * @return The time at which the fleet was created.
     */
    public Date createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The list of fleet errors is appended to this list.
     * </p>
     * 
     * @return The list of fleet errors is appended to this list.
     */
    public List<FleetError> fleetErrors() {
        return fleetErrors;
    }

    /**
     * <p>
     * Whether default Internet access is enabled for the fleet.
     * </p>
     * 
     * @return Whether default Internet access is enabled for the fleet.
     */
    public Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((displayName() == null) ? 0 : displayName().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((imageName() == null) ? 0 : imageName().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((computeCapacityStatus() == null) ? 0 : computeCapacityStatus().hashCode());
        hashCode = 31 * hashCode + ((maxUserDurationInSeconds() == null) ? 0 : maxUserDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + ((disconnectTimeoutInSeconds() == null) ? 0 : disconnectTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((vpcConfig() == null) ? 0 : vpcConfig().hashCode());
        hashCode = 31 * hashCode + ((createdTime() == null) ? 0 : createdTime().hashCode());
        hashCode = 31 * hashCode + ((fleetErrors() == null) ? 0 : fleetErrors().hashCode());
        hashCode = 31 * hashCode + ((enableDefaultInternetAccess() == null) ? 0 : enableDefaultInternetAccess().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.imageName() == null ^ this.imageName() == null) {
            return false;
        }
        if (other.imageName() != null && !other.imageName().equals(this.imageName())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.computeCapacityStatus() == null ^ this.computeCapacityStatus() == null) {
            return false;
        }
        if (other.computeCapacityStatus() != null && !other.computeCapacityStatus().equals(this.computeCapacityStatus())) {
            return false;
        }
        if (other.maxUserDurationInSeconds() == null ^ this.maxUserDurationInSeconds() == null) {
            return false;
        }
        if (other.maxUserDurationInSeconds() != null && !other.maxUserDurationInSeconds().equals(this.maxUserDurationInSeconds())) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() == null ^ this.disconnectTimeoutInSeconds() == null) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() != null
                && !other.disconnectTimeoutInSeconds().equals(this.disconnectTimeoutInSeconds())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.vpcConfig() == null ^ this.vpcConfig() == null) {
            return false;
        }
        if (other.vpcConfig() != null && !other.vpcConfig().equals(this.vpcConfig())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.fleetErrors() == null ^ this.fleetErrors() == null) {
            return false;
        }
        if (other.fleetErrors() != null && !other.fleetErrors().equals(this.fleetErrors())) {
            return false;
        }
        if (other.enableDefaultInternetAccess() == null ^ this.enableDefaultInternetAccess() == null) {
            return false;
        }
        if (other.enableDefaultInternetAccess() != null
                && !other.enableDefaultInternetAccess().equals(this.enableDefaultInternetAccess())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (imageName() != null) {
            sb.append("ImageName: ").append(imageName()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (computeCapacityStatus() != null) {
            sb.append("ComputeCapacityStatus: ").append(computeCapacityStatus()).append(",");
        }
        if (maxUserDurationInSeconds() != null) {
            sb.append("MaxUserDurationInSeconds: ").append(maxUserDurationInSeconds()).append(",");
        }
        if (disconnectTimeoutInSeconds() != null) {
            sb.append("DisconnectTimeoutInSeconds: ").append(disconnectTimeoutInSeconds()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (vpcConfig() != null) {
            sb.append("VpcConfig: ").append(vpcConfig()).append(",");
        }
        if (createdTime() != null) {
            sb.append("CreatedTime: ").append(createdTime()).append(",");
        }
        if (fleetErrors() != null) {
            sb.append("FleetErrors: ").append(fleetErrors()).append(",");
        }
        if (enableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(enableDefaultInternetAccess()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Fleet> {
        /**
         * <p>
         * The ARN for the fleet.
         * </p>
         * 
         * @param arn
         *        The ARN for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param name
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name displayed to end users on the AppStream 2.0 portal.
         * </p>
         * 
         * @param displayName
         *        The name displayed to end users on the AppStream 2.0 portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description displayed to end users on the AppStream 2.0 portal.
         * </p>
         * 
         * @param description
         *        The description displayed to end users on the AppStream 2.0 portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The image used by the fleet.
         * </p>
         * 
         * @param imageName
         *        The image used by the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The instance type of compute resources for the fleet. The fleet instances are launched from this instance
         * type.
         * </p>
         * 
         * @param instanceType
         *        The instance type of compute resources for the fleet. The fleet instances are launched from this
         *        instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The capacity information for the fleet.
         * </p>
         * 
         * @param computeCapacityStatus
         *        The capacity information for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus);

        /**
         * <p>
         * The maximum time for which a streaming session can run. The value can be any numeric value in seconds between
         * 600 and 57600.
         * </p>
         * 
         * @param maxUserDurationInSeconds
         *        The maximum time for which a streaming session can run. The value can be any numeric value in seconds
         *        between 600 and 57600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds);

        /**
         * <p>
         * The time after disconnection when a session is considered to have ended. If a user who got disconnected
         * reconnects within this timeout interval, the user is connected back to their previous session. The input can
         * be any numeric value in seconds between 60 and 57600.
         * </p>
         * 
         * @param disconnectTimeoutInSeconds
         *        The time after disconnection when a session is considered to have ended. If a user who got
         *        disconnected reconnects within this timeout interval, the user is connected back to their previous
         *        session. The input can be any numeric value in seconds between 60 and 57600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds);

        /**
         * <p>
         * The current state for the fleet.
         * </p>
         * 
         * @param state
         *        The current state for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state for the fleet.
         * </p>
         * 
         * @param state
         *        The current state for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetState
         */
        Builder state(FleetState state);

        /**
         * <p>
         * The VPC configuration for the fleet.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The time at which the fleet was created.
         * </p>
         * 
         * @param createdTime
         *        The time at which the fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Date createdTime);

        /**
         * <p>
         * The list of fleet errors is appended to this list.
         * </p>
         * 
         * @param fleetErrors
         *        The list of fleet errors is appended to this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetErrors(Collection<FleetError> fleetErrors);

        /**
         * <p>
         * The list of fleet errors is appended to this list.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFleetErrors(java.util.Collection)} or {@link #withFleetErrors(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param fleetErrors
         *        The list of fleet errors is appended to this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetErrors(FleetError... fleetErrors);

        /**
         * <p>
         * Whether default Internet access is enabled for the fleet.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Whether default Internet access is enabled for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String displayName;

        private String description;

        private String imageName;

        private String instanceType;

        private ComputeCapacityStatus computeCapacityStatus;

        private Integer maxUserDurationInSeconds;

        private Integer disconnectTimeoutInSeconds;

        private String state;

        private VpcConfig vpcConfig;

        private Date createdTime;

        private List<FleetError> fleetErrors;

        private Boolean enableDefaultInternetAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            setArn(model.arn);
            setName(model.name);
            setDisplayName(model.displayName);
            setDescription(model.description);
            setImageName(model.imageName);
            setInstanceType(model.instanceType);
            setComputeCapacityStatus(model.computeCapacityStatus);
            setMaxUserDurationInSeconds(model.maxUserDurationInSeconds);
            setDisconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            setState(model.state);
            setVpcConfig(model.vpcConfig);
            setCreatedTime(model.createdTime);
            setFleetErrors(model.fleetErrors);
            setEnableDefaultInternetAccess(model.enableDefaultInternetAccess);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImageName() {
            return imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final ComputeCapacityStatus getComputeCapacityStatus() {
            return computeCapacityStatus;
        }

        @Override
        public final Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus;
            return this;
        }

        public final void setComputeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FleetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(FleetState state) {
            this.state(state.toString());
        }

        public final VpcConfig getVpcConfig() {
            return vpcConfig;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
        }

        public final Date getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy(createdTime);
            return this;
        }

        public final void setCreatedTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy(createdTime);
        }

        public final Collection<FleetError> getFleetErrors() {
            return fleetErrors;
        }

        @Override
        public final Builder fleetErrors(Collection<FleetError> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copy(fleetErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(FleetError... fleetErrors) {
            if (this.fleetErrors == null) {
                this.fleetErrors = new ArrayList<>(fleetErrors.length);
            }
            for (FleetError e : fleetErrors) {
                this.fleetErrors.add(e);
            }
            return this;
        }

        public final void setFleetErrors(Collection<FleetError> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copy(fleetErrors);
        }

        @SafeVarargs
        public final void setFleetErrors(FleetError... fleetErrors) {
            if (this.fleetErrors == null) {
                this.fleetErrors = new ArrayList<>(fleetErrors.length);
            }
            for (FleetError e : fleetErrors) {
                this.fleetErrors.add(e);
            }
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        @Override
        public Fleet build() {
            return new Fleet(this);
        }
    }
}
