/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.appstream.transform.StackMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Stack implements StructuredPojo, ToCopyableBuilder<Stack.Builder, Stack> {
    private final String arn;

    private final String name;

    private final String description;

    private final String displayName;

    private final Date createdTime;

    private final List<StorageConnector> storageConnectors;

    private final List<StackError> stackErrors;

    private Stack(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.createdTime = builder.createdTime;
        this.storageConnectors = builder.storageConnectors;
        this.stackErrors = builder.stackErrors;
    }

    /**
     * <p>
     * The ARN of the stack.
     * </p>
     * 
     * @return The ARN of the stack.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the stack.
     * </p>
     * 
     * @return The unique identifier of the stack.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A meaningful description for the stack.
     * </p>
     * 
     * @return A meaningful description for the stack.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A display name for the stack.
     * </p>
     * 
     * @return A display name for the stack.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The timestamp when the stack was created.
     * </p>
     * 
     * @return The timestamp when the stack was created.
     */
    public Date createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The storage connectors to be enabled for the stack.
     * </p>
     * 
     * @return The storage connectors to be enabled for the stack.
     */
    public List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * The list of errors associated with the stack.
     * </p>
     * 
     * @return The list of errors associated with the stack.
     */
    public List<StackError> stackErrors() {
        return stackErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((displayName() == null) ? 0 : displayName().hashCode());
        hashCode = 31 * hashCode + ((createdTime() == null) ? 0 : createdTime().hashCode());
        hashCode = 31 * hashCode + ((storageConnectors() == null) ? 0 : storageConnectors().hashCode());
        hashCode = 31 * hashCode + ((stackErrors() == null) ? 0 : stackErrors().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.storageConnectors() == null ^ this.storageConnectors() == null) {
            return false;
        }
        if (other.storageConnectors() != null && !other.storageConnectors().equals(this.storageConnectors())) {
            return false;
        }
        if (other.stackErrors() == null ^ this.stackErrors() == null) {
            return false;
        }
        if (other.stackErrors() != null && !other.stackErrors().equals(this.stackErrors())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (createdTime() != null) {
            sb.append("CreatedTime: ").append(createdTime()).append(",");
        }
        if (storageConnectors() != null) {
            sb.append("StorageConnectors: ").append(storageConnectors()).append(",");
        }
        if (stackErrors() != null) {
            sb.append("StackErrors: ").append(stackErrors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Stack> {
        /**
         * <p>
         * The ARN of the stack.
         * </p>
         * 
         * @param arn
         *        The ARN of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the stack.
         * </p>
         * 
         * @param name
         *        The unique identifier of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A meaningful description for the stack.
         * </p>
         * 
         * @param description
         *        A meaningful description for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A display name for the stack.
         * </p>
         * 
         * @param displayName
         *        A display name for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The timestamp when the stack was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Date createdTime);

        /**
         * <p>
         * The storage connectors to be enabled for the stack.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to be enabled for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to be enabled for the stack.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStorageConnectors(java.util.Collection)} or {@link #withStorageConnectors(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to be enabled for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * The list of errors associated with the stack.
         * </p>
         * 
         * @param stackErrors
         *        The list of errors associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackErrors(Collection<StackError> stackErrors);

        /**
         * <p>
         * The list of errors associated with the stack.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStackErrors(java.util.Collection)} or {@link #withStackErrors(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param stackErrors
         *        The list of errors associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackErrors(StackError... stackErrors);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String displayName;

        private Date createdTime;

        private List<StorageConnector> storageConnectors;

        private List<StackError> stackErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            setArn(model.arn);
            setName(model.name);
            setDescription(model.description);
            setDisplayName(model.displayName);
            setCreatedTime(model.createdTime);
            setStorageConnectors(model.storageConnectors);
            setStackErrors(model.stackErrors);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Date getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy(createdTime);
            return this;
        }

        public final void setCreatedTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy(createdTime);
        }

        public final Collection<StorageConnector> getStorageConnectors() {
            return storageConnectors;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            if (this.storageConnectors == null) {
                this.storageConnectors = new ArrayList<>(storageConnectors.length);
            }
            for (StorageConnector e : storageConnectors) {
                this.storageConnectors.add(e);
            }
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
        }

        @SafeVarargs
        public final void setStorageConnectors(StorageConnector... storageConnectors) {
            if (this.storageConnectors == null) {
                this.storageConnectors = new ArrayList<>(storageConnectors.length);
            }
            for (StorageConnector e : storageConnectors) {
                this.storageConnectors.add(e);
            }
        }

        public final Collection<StackError> getStackErrors() {
            return stackErrors;
        }

        @Override
        public final Builder stackErrors(Collection<StackError> stackErrors) {
            this.stackErrors = StackErrorsCopier.copy(stackErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackErrors(StackError... stackErrors) {
            if (this.stackErrors == null) {
                this.stackErrors = new ArrayList<>(stackErrors.length);
            }
            for (StackError e : stackErrors) {
                this.stackErrors.add(e);
            }
            return this;
        }

        public final void setStackErrors(Collection<StackError> stackErrors) {
            this.stackErrors = StackErrorsCopier.copy(stackErrors);
        }

        @SafeVarargs
        public final void setStackErrors(StackError... stackErrors) {
            if (this.stackErrors == null) {
                this.stackErrors = new ArrayList<>(stackErrors.length);
            }
            for (StackError e : stackErrors) {
                this.stackErrors.add(e);
            }
        }

        @Override
        public Stack build() {
            return new Stack(this);
        }
    }
}
