/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import static java.util.stream.Collectors.toList;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
final class DirectoryConfigListCopier {
    static List<DirectoryConfig> copy(Collection<DirectoryConfig> directoryConfigListParam) {
        if (directoryConfigListParam == null) {
            return null;
        }
        List<DirectoryConfig> directoryConfigListParamCopy = directoryConfigListParam.stream().collect(toList());
        return Collections.unmodifiableList(directoryConfigListParamCopy);
    }

    static List<DirectoryConfig> copyFromBuilder(Collection<? extends DirectoryConfig.Builder> directoryConfigListParam) {
        if (directoryConfigListParam == null) {
            return null;
        }
        return copy(directoryConfigListParam.stream().map(DirectoryConfig.Builder::build).collect(toList()));
    }
}
