/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.appstream.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Image JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImageUnmarshaller implements Unmarshaller<Image, JsonUnmarshallerContext> {

    public Image unmarshall(JsonUnmarshallerContext context) throws Exception {
        Image.Builder imageBuilder = Image.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    imageBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    imageBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BaseImageArn", targetDepth)) {
                    context.nextToken();
                    imageBuilder.baseImageArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    imageBuilder.displayName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    imageBuilder.state(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Visibility", targetDepth)) {
                    context.nextToken();
                    imageBuilder.visibility(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ImageBuilderSupported", targetDepth)) {
                    context.nextToken();
                    imageBuilder.imageBuilderSupported(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("Platform", targetDepth)) {
                    context.nextToken();
                    imageBuilder.platform(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    imageBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StateChangeReason", targetDepth)) {
                    context.nextToken();
                    imageBuilder.stateChangeReason(ImageStateChangeReasonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Applications", targetDepth)) {
                    context.nextToken();
                    imageBuilder.applications(new ListUnmarshaller<Application>(ApplicationUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    context.nextToken();
                    imageBuilder.createdTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("PublicBaseImageReleasedDate", targetDepth)) {
                    context.nextToken();
                    imageBuilder
                            .publicBaseImageReleasedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return imageBuilder.build();
    }

    private static final ImageUnmarshaller INSTANCE = new ImageUnmarshaller();

    public static ImageUnmarshaller getInstance() {
        return INSTANCE;
    }
}
