/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamingUrlRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateStreamingUrlRequest.Builder, CreateStreamingUrlRequest> {
    private final String stackName;

    private final String fleetName;

    private final String userId;

    private final String applicationId;

    private final Long validity;

    private final String sessionContext;

    private CreateStreamingUrlRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.userId = builder.userId;
        this.applicationId = builder.applicationId;
        this.validity = builder.validity;
        this.sessionContext = builder.sessionContext;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The ID of the application that must be launched after the session starts.
     * </p>
     * 
     * @return The ID of the application that must be launched after the session starts.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds.
     * </p>
     * 
     * @return The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds.
     */
    public Long validity() {
        return validity;
    }

    /**
     * <p>
     * The session context of the streaming URL.
     * </p>
     * 
     * @return The session context of the streaming URL.
     */
    public String sessionContext() {
        return sessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        hashCode = 31 * hashCode + Objects.hashCode(sessionContext());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingUrlRequest)) {
            return false;
        }
        CreateStreamingUrlRequest other = (CreateStreamingUrlRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(fleetName(), other.fleetName())
                && Objects.equals(userId(), other.userId()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(validity(), other.validity()) && Objects.equals(sessionContext(), other.sessionContext());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamingUrlRequest").add("StackName", stackName()).add("FleetName", fleetName())
                .add("UserId", userId()).add("ApplicationId", applicationId()).add("Validity", validity())
                .add("SessionContext", sessionContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "FleetName":
            return Optional.ofNullable(clazz.cast(fleetName()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Validity":
            return Optional.ofNullable(clazz.cast(validity()));
        case "SessionContext":
            return Optional.ofNullable(clazz.cast(sessionContext()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, CreateStreamingUrlRequest> {
        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param stackName
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param userId
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The ID of the application that must be launched after the session starts.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application that must be launched after the session starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds.
         * </p>
         * 
         * @param validity
         *        The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(Long validity);

        /**
         * <p>
         * The session context of the streaming URL.
         * </p>
         * 
         * @param sessionContext
         *        The session context of the streaming URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionContext(String sessionContext);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String stackName;

        private String fleetName;

        private String userId;

        private String applicationId;

        private Long validity;

        private String sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingUrlRequest model) {
            super(model);
            stackName(model.stackName);
            fleetName(model.fleetName);
            userId(model.userId);
            applicationId(model.applicationId);
            validity(model.validity);
            sessionContext(model.sessionContext);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Long getValidity() {
            return validity;
        }

        @Override
        public final Builder validity(Long validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(Long validity) {
            this.validity = validity;
        }

        public final String getSessionContext() {
            return sessionContext;
        }

        @Override
        public final Builder sessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public final void setSessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamingUrlRequest build() {
            return new CreateStreamingUrlRequest(this);
        }
    }
}
