/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSessionsRequest extends AppStreamRequest implements
        ToCopyableBuilder<DescribeSessionsRequest.Builder, DescribeSessionsRequest> {
    private final String stackName;

    private final String fleetName;

    private final String userId;

    private final String nextToken;

    private final Integer limit;

    private final String authenticationType;

    private DescribeSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.userId = builder.userId;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.authenticationType = builder.authenticationType;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The user ID.
     * </p>
     * 
     * @return The user ID.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The size of each page of results. The default value is 20 and the maximum value is 50.
     * </p>
     * 
     * @return The size of each page of results. The default value is 20 and the maximum value is 50.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or
     * <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or
     *         <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.
     * @see AuthenticationType
     */
    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or
     * <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or
     *         <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.
     * @see AuthenticationType
     */
    public String authenticationTypeAsString() {
        return authenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSessionsRequest)) {
            return false;
        }
        DescribeSessionsRequest other = (DescribeSessionsRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(fleetName(), other.fleetName())
                && Objects.equals(userId(), other.userId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(limit(), other.limit())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSessionsRequest").add("StackName", stackName()).add("FleetName", fleetName())
                .add("UserId", userId()).add("NextToken", nextToken()).add("Limit", limit())
                .add("AuthenticationType", authenticationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "FleetName":
            return Optional.ofNullable(clazz.cast(fleetName()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, DescribeSessionsRequest> {
        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param stackName
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The user ID.
         * </p>
         * 
         * @param userId
         *        The user ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The size of each page of results. The default value is 20 and the maximum value is 50.
         * </p>
         * 
         * @param limit
         *        The size of each page of results. The default value is 20 and the maximum value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or
         * <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.
         * </p>
         * 
         * @param authenticationType
         *        The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or
         *        <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming
         *        URL.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or
         * <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.
         * </p>
         * 
         * @param authenticationType
         *        The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or
         *        <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming
         *        URL.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String stackName;

        private String fleetName;

        private String userId;

        private String nextToken;

        private Integer limit;

        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSessionsRequest model) {
            super(model);
            stackName(model.stackName);
            fleetName(model.fleetName);
            userId(model.userId);
            nextToken(model.nextToken);
            limit(model.limit);
            authenticationType(model.authenticationType);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSessionsRequest build() {
            return new DescribeSessionsRequest(this);
        }
    }
}
