/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.Image;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Image} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ImageMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();

    private static final MarshallingInfo<String> BASEIMAGEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaseImageArn").isBinary(false).build();

    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").isBinary(false).build();

    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();

    private static final MarshallingInfo<String> VISIBILITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Visibility").isBinary(false).build();

    private static final MarshallingInfo<Boolean> IMAGEBUILDERSUPPORTED_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ImageBuilderSupported").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> STATECHANGEREASON_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("StateChangeReason").isBinary(false).build();

    private static final MarshallingInfo<List> APPLICATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Applications").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> PUBLICBASEIMAGERELEASEDDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PublicBaseImageReleasedDate").isBinary(false).build();

    private static final ImageMarshaller INSTANCE = new ImageMarshaller();

    private ImageMarshaller() {
    }

    public static ImageMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Image image, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(image, "image");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(image.name(), NAME_BINDING);
            protocolMarshaller.marshall(image.arn(), ARN_BINDING);
            protocolMarshaller.marshall(image.baseImageArn(), BASEIMAGEARN_BINDING);
            protocolMarshaller.marshall(image.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(image.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall(image.visibilityAsString(), VISIBILITY_BINDING);
            protocolMarshaller.marshall(image.imageBuilderSupported(), IMAGEBUILDERSUPPORTED_BINDING);
            protocolMarshaller.marshall(image.platformAsString(), PLATFORM_BINDING);
            protocolMarshaller.marshall(image.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(image.stateChangeReason(), STATECHANGEREASON_BINDING);
            protocolMarshaller.marshall(image.applications(), APPLICATIONS_BINDING);
            protocolMarshaller.marshall(image.createdTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall(image.publicBaseImageReleasedDate(), PUBLICBASEIMAGERELEASEDDATE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
