/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.StorageConnectorType;
import software.amazon.awssdk.services.appstream.transform.StorageConnectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageConnector
implements StructuredPojo,
ToCopyableBuilder<Builder, StorageConnector> {
    private final String connectorType;
    private final String resourceIdentifier;

    private StorageConnector(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    public StorageConnectorType connectorType() {
        return StorageConnectorType.fromValue(this.connectorType);
    }

    public String connectorTypeAsString() {
        return this.connectorType;
    }

    public String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConnector)) {
            return false;
        }
        StorageConnector other = (StorageConnector)obj;
        return Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"StorageConnector").add("ConnectorType", (Object)this.connectorTypeAsString()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageConnectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorType;
        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConnector model) {
            this.connectorType(model.connectorType);
            this.resourceIdentifier(model.resourceIdentifier);
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(StorageConnectorType connectorType) {
            this.connectorType(connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public StorageConnector build() {
            return new StorageConnector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageConnector> {
        public Builder connectorType(String var1);

        public Builder connectorType(StorageConnectorType var1);

        public Builder resourceIdentifier(String var1);
    }
}

