/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VisibilityType {
    PUBLIC("PUBLIC"),
    PRIVATE("PRIVATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private VisibilityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VisibilityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(VisibilityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VisibilityType> knownValues() {
        return Stream.of(VisibilityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

