/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStackRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateStackRequest.Builder, CreateStackRequest> {
    private final String name;

    private final String description;

    private final String displayName;

    private final List<StorageConnector> storageConnectors;

    private final String redirectURL;

    private final String feedbackURL;

    private final List<UserSetting> userSettings;

    private final ApplicationSettings applicationSettings;

    private CreateStackRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.storageConnectors = builder.storageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description for display.
     * </p>
     * 
     * @return The description for display.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The stack name for display.
     * </p>
     * 
     * @return The stack name for display.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The storage connectors to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The storage connectors to enable.
     */
    public List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * The URL that users are redirected to after their streaming session ends.
     * </p>
     * 
     * @return The URL that users are redirected to after their streaming session ends.
     */
    public String redirectURL() {
        return redirectURL;
    }

    /**
     * <p>
     * The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send
     * Feedback link is displayed.
     * </p>
     * 
     * @return The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no
     *         Send Feedback link is displayed.
     */
    public String feedbackURL() {
        return feedbackURL;
    }

    /**
     * <p>
     * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are
     * enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The actions that are enabled or disabled for users during their streaming sessions. By default, these
     *         actions are enabled.
     */
    public List<UserSetting> userSettings() {
        return userSettings;
    }

    /**
     * <p>
     * The persistent application settings for users of a stack. When these settings are enabled, changes that users
     * make to applications and Windows settings are automatically saved after each session and applied to the next
     * session.
     * </p>
     * 
     * @return The persistent application settings for users of a stack. When these settings are enabled, changes that
     *         users make to applications and Windows settings are automatically saved after each session and applied to
     *         the next session.
     */
    public ApplicationSettings applicationSettings() {
        return applicationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(storageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(userSettings());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(storageConnectors(), other.storageConnectors())
                && Objects.equals(redirectURL(), other.redirectURL()) && Objects.equals(feedbackURL(), other.feedbackURL())
                && Objects.equals(userSettings(), other.userSettings())
                && Objects.equals(applicationSettings(), other.applicationSettings());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStackRequest").add("Name", name()).add("Description", description())
                .add("DisplayName", displayName()).add("StorageConnectors", storageConnectors())
                .add("RedirectURL", redirectURL()).add("FeedbackURL", feedbackURL()).add("UserSettings", userSettings())
                .add("ApplicationSettings", applicationSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "StorageConnectors":
            return Optional.ofNullable(clazz.cast(storageConnectors()));
        case "RedirectURL":
            return Optional.ofNullable(clazz.cast(redirectURL()));
        case "FeedbackURL":
            return Optional.ofNullable(clazz.cast(feedbackURL()));
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        case "ApplicationSettings":
            return Optional.ofNullable(clazz.cast(applicationSettings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, CreateStackRequest> {
        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param name
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for display.
         * </p>
         * 
         * @param description
         *        The description for display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stack name for display.
         * </p>
         * 
         * @param displayName
         *        The stack name for display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StorageConnector>.Builder} avoiding the
         * need to create one manually via {@link List<StorageConnector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageConnector>.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConnectors(List<StorageConnector>)}.
         * 
         * @param storageConnectors
         *        a consumer that will call methods on {@link List<StorageConnector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConnectors(List<StorageConnector>)
         */
        Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors);

        /**
         * <p>
         * The URL that users are redirected to after their streaming session ends.
         * </p>
         * 
         * @param redirectURL
         *        The URL that users are redirected to after their streaming session ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectURL(String redirectURL);

        /**
         * <p>
         * The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send
         * Feedback link is displayed.
         * </p>
         * 
         * @param feedbackURL
         *        The URL that users are redirected to after they click the Send Feedback link. If no URL is specified,
         *        no Send Feedback link is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackURL(String feedbackURL);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * 
         * @param userSettings
         *        The actions that are enabled or disabled for users during their streaming sessions. By default, these
         *        actions are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(Collection<UserSetting> userSettings);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * 
         * @param userSettings
         *        The actions that are enabled or disabled for users during their streaming sessions. By default, these
         *        actions are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSetting... userSettings);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserSetting>.Builder} avoiding the need to
         * create one manually via {@link List<UserSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserSetting>.Builder#build()} is called immediately and its
         * result is passed to {@link #userSettings(List<UserSetting>)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on {@link List<UserSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(List<UserSetting>)
         */
        Builder userSettings(Consumer<UserSetting.Builder>... userSettings);

        /**
         * <p>
         * The persistent application settings for users of a stack. When these settings are enabled, changes that users
         * make to applications and Windows settings are automatically saved after each session and applied to the next
         * session.
         * </p>
         * 
         * @param applicationSettings
         *        The persistent application settings for users of a stack. When these settings are enabled, changes
         *        that users make to applications and Windows settings are automatically saved after each session and
         *        applied to the next session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSettings(ApplicationSettings applicationSettings);

        /**
         * <p>
         * The persistent application settings for users of a stack. When these settings are enabled, changes that users
         * make to applications and Windows settings are automatically saved after each session and applied to the next
         * session.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSettings.Builder} avoiding the need
         * to create one manually via {@link ApplicationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationSettings(ApplicationSettings)}.
         * 
         * @param applicationSettings
         *        a consumer that will call methods on {@link ApplicationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSettings(ApplicationSettings)
         */
        default Builder applicationSettings(Consumer<ApplicationSettings.Builder> applicationSettings) {
            return applicationSettings(ApplicationSettings.builder().applyMutation(applicationSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String displayName;

        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();

        private String redirectURL;

        private String feedbackURL;

        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();

        private ApplicationSettings applicationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            displayName(model.displayName);
            storageConnectors(model.storageConnectors);
            redirectURL(model.redirectURL);
            feedbackURL(model.feedbackURL);
            userSettings(model.userSettings);
            applicationSettings(model.applicationSettings);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return storageConnectors != null ? storageConnectors.stream().map(StorageConnector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors) {
            storageConnectors(Stream.of(storageConnectors).map(c -> StorageConnector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final String getRedirectURL() {
            return redirectURL;
        }

        @Override
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        public final String getFeedbackURL() {
            return feedbackURL;
        }

        @Override
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        public final Collection<UserSetting.Builder> getUserSettings() {
            return userSettings != null ? userSettings.stream().map(UserSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting... userSettings) {
            userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder>... userSettings) {
            userSettings(Stream.of(userSettings).map(c -> UserSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        public final ApplicationSettings.Builder getApplicationSettings() {
            return applicationSettings != null ? applicationSettings.toBuilder() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettings applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final void setApplicationSettings(ApplicationSettings.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }
    }
}
