/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteImagePermissionsRequest extends AppStreamRequest implements
        ToCopyableBuilder<DeleteImagePermissionsRequest.Builder, DeleteImagePermissionsRequest> {
    private final String name;

    private final String sharedAccountId;

    private DeleteImagePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sharedAccountId = builder.sharedAccountId;
    }

    /**
     * <p>
     * The name of the private image.
     * </p>
     * 
     * @return The name of the private image.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The 12-digit ID of the AWS account for which to delete image permissions.
     * </p>
     * 
     * @return The 12-digit ID of the AWS account for which to delete image permissions.
     */
    public String sharedAccountId() {
        return sharedAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImagePermissionsRequest)) {
            return false;
        }
        DeleteImagePermissionsRequest other = (DeleteImagePermissionsRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(sharedAccountId(), other.sharedAccountId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteImagePermissionsRequest").add("Name", name()).add("SharedAccountId", sharedAccountId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, DeleteImagePermissionsRequest> {
        /**
         * <p>
         * The name of the private image.
         * </p>
         * 
         * @param name
         *        The name of the private image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The 12-digit ID of the AWS account for which to delete image permissions.
         * </p>
         * 
         * @param sharedAccountId
         *        The 12-digit ID of the AWS account for which to delete image permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String sharedAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImagePermissionsRequest model) {
            super(model);
            name(model.name);
            sharedAccountId(model.sharedAccountId);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteImagePermissionsRequest build() {
            return new DeleteImagePermissionsRequest(this);
        }
    }
}
