/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagePermissionsResponse extends AppStreamResponse implements
        ToCopyableBuilder<DescribeImagePermissionsResponse.Builder, DescribeImagePermissionsResponse> {
    private final String name;

    private final List<SharedImagePermissions> sharedImagePermissionsList;

    private final String nextToken;

    private DescribeImagePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sharedImagePermissionsList = builder.sharedImagePermissionsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the private image.
     * </p>
     * 
     * @return The name of the private image.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The permissions for a private image that you own.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The permissions for a private image that you own.
     */
    public List<SharedImagePermissions> sharedImagePermissionsList() {
        return sharedImagePermissionsList;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results. If this value is empty, only the first page is
     * retrieved.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results. If this value is empty, only the first
     *         page is retrieved.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sharedImagePermissionsList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagePermissionsResponse)) {
            return false;
        }
        DescribeImagePermissionsResponse other = (DescribeImagePermissionsResponse) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(sharedImagePermissionsList(), other.sharedImagePermissionsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeImagePermissionsResponse").add("Name", name())
                .add("SharedImagePermissionsList", sharedImagePermissionsList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SharedImagePermissionsList":
            return Optional.ofNullable(clazz.cast(sharedImagePermissionsList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, DescribeImagePermissionsResponse> {
        /**
         * <p>
         * The name of the private image.
         * </p>
         * 
         * @param name
         *        The name of the private image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The permissions for a private image that you own.
         * </p>
         * 
         * @param sharedImagePermissionsList
         *        The permissions for a private image that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedImagePermissionsList(Collection<SharedImagePermissions> sharedImagePermissionsList);

        /**
         * <p>
         * The permissions for a private image that you own.
         * </p>
         * 
         * @param sharedImagePermissionsList
         *        The permissions for a private image that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedImagePermissionsList(SharedImagePermissions... sharedImagePermissionsList);

        /**
         * <p>
         * The permissions for a private image that you own.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SharedImagePermissions>.Builder} avoiding
         * the need to create one manually via {@link List<SharedImagePermissions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SharedImagePermissions>.Builder#build()} is called
         * immediately and its result is passed to {@link #sharedImagePermissionsList(List<SharedImagePermissions>)}.
         * 
         * @param sharedImagePermissionsList
         *        a consumer that will call methods on {@link List<SharedImagePermissions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharedImagePermissionsList(List<SharedImagePermissions>)
         */
        Builder sharedImagePermissionsList(Consumer<SharedImagePermissions.Builder>... sharedImagePermissionsList);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results. If this value is empty, only the first page
         * is retrieved.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results. If this value is empty, only the
         *        first page is retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private String name;

        private List<SharedImagePermissions> sharedImagePermissionsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagePermissionsResponse model) {
            super(model);
            name(model.name);
            sharedImagePermissionsList(model.sharedImagePermissionsList);
            nextToken(model.nextToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SharedImagePermissions.Builder> getSharedImagePermissionsList() {
            return sharedImagePermissionsList != null ? sharedImagePermissionsList.stream()
                    .map(SharedImagePermissions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sharedImagePermissionsList(Collection<SharedImagePermissions> sharedImagePermissionsList) {
            this.sharedImagePermissionsList = SharedImagePermissionsListCopier.copy(sharedImagePermissionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedImagePermissionsList(SharedImagePermissions... sharedImagePermissionsList) {
            sharedImagePermissionsList(Arrays.asList(sharedImagePermissionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedImagePermissionsList(Consumer<SharedImagePermissions.Builder>... sharedImagePermissionsList) {
            sharedImagePermissionsList(Stream.of(sharedImagePermissionsList)
                    .map(c -> SharedImagePermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSharedImagePermissionsList(Collection<SharedImagePermissions.BuilderImpl> sharedImagePermissionsList) {
            this.sharedImagePermissionsList = SharedImagePermissionsListCopier.copyFromBuilder(sharedImagePermissionsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImagePermissionsResponse build() {
            return new DescribeImagePermissionsResponse(this);
        }
    }
}
