/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ImagePermissionsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the permissions for an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImagePermissions implements StructuredPojo, ToCopyableBuilder<ImagePermissions.Builder, ImagePermissions> {
    private final Boolean allowFleet;

    private final Boolean allowImageBuilder;

    private ImagePermissions(BuilderImpl builder) {
        this.allowFleet = builder.allowFleet;
        this.allowImageBuilder = builder.allowImageBuilder;
    }

    /**
     * <p>
     * Indicates whether the image can be used for a fleet.
     * </p>
     * 
     * @return Indicates whether the image can be used for a fleet.
     */
    public Boolean allowFleet() {
        return allowFleet;
    }

    /**
     * <p>
     * Indicates whether the image can be used for an image builder.
     * </p>
     * 
     * @return Indicates whether the image can be used for an image builder.
     */
    public Boolean allowImageBuilder() {
        return allowImageBuilder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowFleet());
        hashCode = 31 * hashCode + Objects.hashCode(allowImageBuilder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImagePermissions)) {
            return false;
        }
        ImagePermissions other = (ImagePermissions) obj;
        return Objects.equals(allowFleet(), other.allowFleet()) && Objects.equals(allowImageBuilder(), other.allowImageBuilder());
    }

    @Override
    public String toString() {
        return ToString.builder("ImagePermissions").add("AllowFleet", allowFleet()).add("AllowImageBuilder", allowImageBuilder())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowFleet":
            return Optional.ofNullable(clazz.cast(allowFleet()));
        case "allowImageBuilder":
            return Optional.ofNullable(clazz.cast(allowImageBuilder()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImagePermissionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ImagePermissions> {
        /**
         * <p>
         * Indicates whether the image can be used for a fleet.
         * </p>
         * 
         * @param allowFleet
         *        Indicates whether the image can be used for a fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowFleet(Boolean allowFleet);

        /**
         * <p>
         * Indicates whether the image can be used for an image builder.
         * </p>
         * 
         * @param allowImageBuilder
         *        Indicates whether the image can be used for an image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowImageBuilder(Boolean allowImageBuilder);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowFleet;

        private Boolean allowImageBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(ImagePermissions model) {
            allowFleet(model.allowFleet);
            allowImageBuilder(model.allowImageBuilder);
        }

        public final Boolean getAllowFleet() {
            return allowFleet;
        }

        @Override
        public final Builder allowFleet(Boolean allowFleet) {
            this.allowFleet = allowFleet;
            return this;
        }

        public final void setAllowFleet(Boolean allowFleet) {
            this.allowFleet = allowFleet;
        }

        public final Boolean getAllowImageBuilder() {
            return allowImageBuilder;
        }

        @Override
        public final Builder allowImageBuilder(Boolean allowImageBuilder) {
            this.allowImageBuilder = allowImageBuilder;
            return this;
        }

        public final void setAllowImageBuilder(Boolean allowImageBuilder) {
            this.allowImageBuilder = allowImageBuilder;
        }

        @Override
        public ImagePermissions build() {
            return new ImagePermissions(this);
        }
    }
}
