/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagResourceRequest extends AppStreamRequest implements
        ToCopyableBuilder<TagResourceRequest.Builder, TagResourceRequest> {
    private final String resourceArn;

    private final Map<String, String> tags;

    private TagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The tags to associate. A tag is a key-value pair (the value is optional). For example,
     * <code>Environment=Test</code>, or, if you do not specify a value, <code>Environment=</code>.
     * </p>
     * <p>
     * If you do not specify a value, we set the value to an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to associate. A tag is a key-value pair (the value is optional). For example,
     *         <code>Environment=Test</code>, or, if you do not specify a value, <code>Environment=</code>. </p>
     *         <p>
     *         If you do not specify a value, we set the value to an empty string.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("TagResourceRequest").add("ResourceArn", resourceArn()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, TagResourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The tags to associate. A tag is a key-value pair (the value is optional). For example,
         * <code>Environment=Test</code>, or, if you do not specify a value, <code>Environment=</code>.
         * </p>
         * <p>
         * If you do not specify a value, we set the value to an empty string.
         * </p>
         * 
         * @param tags
         *        The tags to associate. A tag is a key-value pair (the value is optional). For example,
         *        <code>Environment=Test</code>, or, if you do not specify a value, <code>Environment=</code>. </p>
         *        <p>
         *        If you do not specify a value, we set the value to an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            tags(model.tags);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TagResourceRequest build() {
            return new TagResourceRequest(this);
        }
    }
}
