/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.UserSettingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action and whether the action is enabled or disabled for users during their streaming sessions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserSetting implements StructuredPojo, ToCopyableBuilder<UserSetting.Builder, UserSetting> {
    private final String action;

    private final String permission;

    private UserSetting(BuilderImpl builder) {
        this.action = builder.action;
        this.permission = builder.permission;
    }

    /**
     * <p>
     * The action that is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that is enabled or disabled.
     * @see Action
     */
    public Action action() {
        return Action.fromValue(action);
    }

    /**
     * <p>
     * The action that is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that is enabled or disabled.
     * @see Action
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Indicates whether the action is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return Indicates whether the action is enabled or disabled.
     * @see Permission
     */
    public Permission permission() {
        return Permission.fromValue(permission);
    }

    /**
     * <p>
     * Indicates whether the action is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return Indicates whether the action is enabled or disabled.
     * @see Permission
     */
    public String permissionAsString() {
        return permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSetting)) {
            return false;
        }
        UserSetting other = (UserSetting) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(permissionAsString(), other.permissionAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("UserSetting").add("Action", actionAsString()).add("Permission", permissionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserSettingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, UserSetting> {
        /**
         * <p>
         * The action that is enabled or disabled.
         * </p>
         * 
         * @param action
         *        The action that is enabled or disabled.
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * <p>
         * The action that is enabled or disabled.
         * </p>
         * 
         * @param action
         *        The action that is enabled or disabled.
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * <p>
         * Indicates whether the action is enabled or disabled.
         * </p>
         * 
         * @param permission
         *        Indicates whether the action is enabled or disabled.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(String permission);

        /**
         * <p>
         * Indicates whether the action is enabled or disabled.
         * </p>
         * 
         * @param permission
         *        Indicates whether the action is enabled or disabled.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(Permission permission);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSetting model) {
            action(model.action);
            permission(model.permission);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getPermission() {
            return permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public UserSetting build() {
            return new UserSetting(this);
        }
    }
}
