/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link NetworkAccessConfiguration} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class NetworkAccessConfigurationMarshaller {
    private static final MarshallingInfo<String> ENIPRIVATEIPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniPrivateIpAddress").isBinary(false).build();

    private static final MarshallingInfo<String> ENIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniId").isBinary(false).build();

    private static final NetworkAccessConfigurationMarshaller INSTANCE = new NetworkAccessConfigurationMarshaller();

    private NetworkAccessConfigurationMarshaller() {
    }

    public static NetworkAccessConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(NetworkAccessConfiguration networkAccessConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(networkAccessConfiguration, "networkAccessConfiguration");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(networkAccessConfiguration.eniPrivateIpAddress(), ENIPRIVATEIPADDRESS_BINDING);
            protocolMarshaller.marshall(networkAccessConfiguration.eniId(), ENIID_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
