/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ApplicationSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationSettings> {
    private final Boolean enabled;
    private final String settingsGroup;

    private ApplicationSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.settingsGroup = builder.settingsGroup;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String settingsGroup() {
        return this.settingsGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.settingsGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettings)) {
            return false;
        }
        ApplicationSettings other = (ApplicationSettings)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.settingsGroup(), other.settingsGroup());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationSettings").add("Enabled", (Object)this.enabled()).add("SettingsGroup", (Object)this.settingsGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SettingsGroup": {
                return Optional.ofNullable(clazz.cast(this.settingsGroup()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String settingsGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettings model) {
            this.enabled(model.enabled);
            this.settingsGroup(model.settingsGroup);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSettingsGroup() {
            return this.settingsGroup;
        }

        @Override
        public final Builder settingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
            return this;
        }

        public final void setSettingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
        }

        public ApplicationSettings build() {
            return new ApplicationSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationSettings> {
        public Builder enabled(Boolean var1);

        public Builder settingsGroup(String var1);
    }
}

