/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.Application;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplicationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").isBinary(false).build();
    private static final MarshallingInfo<String> ICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IconURL").isBinary(false).build();
    private static final MarshallingInfo<String> LAUNCHPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchPath").isBinary(false).build();
    private static final MarshallingInfo<String> LAUNCHPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchParameters").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<Map> METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metadata").isBinary(false).build();
    private static final ApplicationMarshaller INSTANCE = new ApplicationMarshaller();

    private ApplicationMarshaller() {
    }

    public static ApplicationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Application application, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)application, (String)"application");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)application.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)application.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)application.iconURL(), ICONURL_BINDING);
            protocolMarshaller.marshall((Object)application.launchPath(), LAUNCHPATH_BINDING);
            protocolMarshaller.marshall((Object)application.launchParameters(), LAUNCHPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)application.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(application.metadata(), METADATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

