/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.ApplicationSettingsResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplicationSettingsResponseMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> SETTINGSGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SettingsGroup").isBinary(false).build();
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketName").isBinary(false).build();
    private static final ApplicationSettingsResponseMarshaller INSTANCE = new ApplicationSettingsResponseMarshaller();

    private ApplicationSettingsResponseMarshaller() {
    }

    public static ApplicationSettingsResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationSettingsResponse applicationSettingsResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)applicationSettingsResponse, (String)"applicationSettingsResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)applicationSettingsResponse.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)applicationSettingsResponse.settingsGroup(), SETTINGSGROUP_BINDING);
            protocolMarshaller.marshall((Object)applicationSettingsResponse.s3BucketName(), S3BUCKETNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

