/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest;
import software.amazon.awssdk.services.appstream.transform.DescribeDirectoryConfigsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeDirectoryConfigsRequestMarshaller
implements Marshaller<Request<DescribeDirectoryConfigsRequest>, DescribeDirectoryConfigsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("PhotonAdminProxyService.DescribeDirectoryConfigs").serviceName("Amazon AppStream").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DescribeDirectoryConfigsRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeDirectoryConfigsRequest> marshall(DescribeDirectoryConfigsRequest describeDirectoryConfigsRequest) {
        Validate.paramNotNull((Object)((Object)describeDirectoryConfigsRequest), (String)"describeDirectoryConfigsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeDirectoryConfigsRequest);
            protocolMarshaller.startMarshalling();
            DescribeDirectoryConfigsRequestModelMarshaller.getInstance().marshall(describeDirectoryConfigsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

