/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceAccountCredentialsMarshaller {
    private static final MarshallingInfo<String> ACCOUNTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountName").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountPassword").isBinary(false).build();
    private static final ServiceAccountCredentialsMarshaller INSTANCE = new ServiceAccountCredentialsMarshaller();

    private ServiceAccountCredentialsMarshaller() {
    }

    public static ServiceAccountCredentialsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServiceAccountCredentials serviceAccountCredentials, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serviceAccountCredentials, (String)"serviceAccountCredentials");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serviceAccountCredentials.accountName(), ACCOUNTNAME_BINDING);
            protocolMarshaller.marshall((Object)serviceAccountCredentials.accountPassword(), ACCOUNTPASSWORD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

