/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStacksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeStacksResponse.Builder, DescribeStacksResponse> {
    private final List<Stack> stacks;

    private final String nextToken;

    private DescribeStacksResponse(BuilderImpl builder) {
        this.stacks = builder.stacks;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of stack details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of stack details.
     */
    public List<Stack> stacks() {
        return stacks;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stacks() == null) ? 0 : stacks().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse) obj;
        if (other.stacks() == null ^ this.stacks() == null) {
            return false;
        }
        if (other.stacks() != null && !other.stacks().equals(this.stacks())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stacks() != null) {
            sb.append("Stacks: ").append(stacks()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStacksResponse> {
        /**
         * <p>
         * The list of stack details.
         * </p>
         * 
         * @param stacks
         *        The list of stack details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Collection<Stack> stacks);

        /**
         * <p>
         * The list of stack details.
         * </p>
         * 
         * @param stacks
         *        The list of stack details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Stack... stacks);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Stack> stacks;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            setStacks(model.stacks);
            setNextToken(model.nextToken);
        }

        public final Collection<Stack> getStacks() {
            return stacks;
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StackListCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack... stacks) {
            stacks(Arrays.asList(stacks));
            return this;
        }

        public final void setStacks(Collection<Stack> stacks) {
            this.stacks = StackListCopier.copy(stacks);
        }

        @SafeVarargs
        public final void setStacks(Stack... stacks) {
            stacks(Arrays.asList(stacks));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }
    }
}
