/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ImageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * New streaming instances are booted from images. The image stores the application catalog and is connected to fleets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Image implements StructuredPojo, ToCopyableBuilder<Image.Builder, Image> {
    private final String name;

    private final String arn;

    private final String baseImageArn;

    private final String displayName;

    private final String state;

    private final String visibility;

    private final Boolean imageBuilderSupported;

    private final String platform;

    private final String description;

    private final ImageStateChangeReason stateChangeReason;

    private final List<Application> applications;

    private final Instant createdTime;

    private final Instant publicBaseImageReleasedDate;

    private Image(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.baseImageArn = builder.baseImageArn;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.visibility = builder.visibility;
        this.imageBuilderSupported = builder.imageBuilderSupported;
        this.platform = builder.platform;
        this.description = builder.description;
        this.stateChangeReason = builder.stateChangeReason;
        this.applications = builder.applications;
        this.createdTime = builder.createdTime;
        this.publicBaseImageReleasedDate = builder.publicBaseImageReleasedDate;
    }

    /**
     * <p>
     * The unique identifier for the image.
     * </p>
     * 
     * @return The unique identifier for the image.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ARN for the image.
     * </p>
     * 
     * @return The ARN for the image.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The source image ARN from which this image was created.
     * </p>
     * 
     * @return The source image ARN from which this image was created.
     */
    public String baseImageArn() {
        return baseImageArn;
    }

    /**
     * <p>
     * The display name for the image.
     * </p>
     * 
     * @return The display name for the image.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The image starts in the <b>PENDING</b> state, and then moves to <b>AVAILABLE</b> if image creation succeeds and
     * <b>FAILED</b> if image creation has failed.
     * </p>
     * 
     * @return The image starts in the <b>PENDING</b> state, and then moves to <b>AVAILABLE</b> if image creation
     *         succeeds and <b>FAILED</b> if image creation has failed.
     * @see ImageState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The visibility of an image to the user; images can be public or private.
     * </p>
     * 
     * @return The visibility of an image to the user; images can be public or private.
     * @see VisibilityType
     */
    public String visibility() {
        return visibility;
    }

    /**
     * <p>
     * Whether an image builder can be launched from this image.
     * </p>
     * 
     * @return Whether an image builder can be launched from this image.
     */
    public Boolean imageBuilderSupported() {
        return imageBuilderSupported;
    }

    /**
     * <p>
     * The operating system platform of the image.
     * </p>
     * 
     * @return The operating system platform of the image.
     * @see PlatformType
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * A meaningful description for the image.
     * </p>
     * 
     * @return A meaningful description for the image.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The reason why the last state change occurred.
     * </p>
     * 
     * @return The reason why the last state change occurred.
     */
    public ImageStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * The applications associated with an image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The applications associated with an image.
     */
    public List<Application> applications() {
        return applications;
    }

    /**
     * <p>
     * The timestamp when the image was created.
     * </p>
     * 
     * @return The timestamp when the image was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The AWS release date of the public base image. For private images, this date is the release date of the base
     * image from which the image was created.
     * </p>
     * 
     * @return The AWS release date of the public base image. For private images, this date is the release date of the
     *         base image from which the image was created.
     */
    public Instant publicBaseImageReleasedDate() {
        return publicBaseImageReleasedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((baseImageArn() == null) ? 0 : baseImageArn().hashCode());
        hashCode = 31 * hashCode + ((displayName() == null) ? 0 : displayName().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((visibility() == null) ? 0 : visibility().hashCode());
        hashCode = 31 * hashCode + ((imageBuilderSupported() == null) ? 0 : imageBuilderSupported().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((stateChangeReason() == null) ? 0 : stateChangeReason().hashCode());
        hashCode = 31 * hashCode + ((applications() == null) ? 0 : applications().hashCode());
        hashCode = 31 * hashCode + ((createdTime() == null) ? 0 : createdTime().hashCode());
        hashCode = 31 * hashCode + ((publicBaseImageReleasedDate() == null) ? 0 : publicBaseImageReleasedDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.baseImageArn() == null ^ this.baseImageArn() == null) {
            return false;
        }
        if (other.baseImageArn() != null && !other.baseImageArn().equals(this.baseImageArn())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.visibility() == null ^ this.visibility() == null) {
            return false;
        }
        if (other.visibility() != null && !other.visibility().equals(this.visibility())) {
            return false;
        }
        if (other.imageBuilderSupported() == null ^ this.imageBuilderSupported() == null) {
            return false;
        }
        if (other.imageBuilderSupported() != null && !other.imageBuilderSupported().equals(this.imageBuilderSupported())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.stateChangeReason() == null ^ this.stateChangeReason() == null) {
            return false;
        }
        if (other.stateChangeReason() != null && !other.stateChangeReason().equals(this.stateChangeReason())) {
            return false;
        }
        if (other.applications() == null ^ this.applications() == null) {
            return false;
        }
        if (other.applications() != null && !other.applications().equals(this.applications())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.publicBaseImageReleasedDate() == null ^ this.publicBaseImageReleasedDate() == null) {
            return false;
        }
        if (other.publicBaseImageReleasedDate() != null
                && !other.publicBaseImageReleasedDate().equals(this.publicBaseImageReleasedDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (baseImageArn() != null) {
            sb.append("BaseImageArn: ").append(baseImageArn()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (visibility() != null) {
            sb.append("Visibility: ").append(visibility()).append(",");
        }
        if (imageBuilderSupported() != null) {
            sb.append("ImageBuilderSupported: ").append(imageBuilderSupported()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(stateChangeReason()).append(",");
        }
        if (applications() != null) {
            sb.append("Applications: ").append(applications()).append(",");
        }
        if (createdTime() != null) {
            sb.append("CreatedTime: ").append(createdTime()).append(",");
        }
        if (publicBaseImageReleasedDate() != null) {
            sb.append("PublicBaseImageReleasedDate: ").append(publicBaseImageReleasedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Image> {
        /**
         * <p>
         * The unique identifier for the image.
         * </p>
         * 
         * @param name
         *        The unique identifier for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN for the image.
         * </p>
         * 
         * @param arn
         *        The ARN for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The source image ARN from which this image was created.
         * </p>
         * 
         * @param baseImageArn
         *        The source image ARN from which this image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseImageArn(String baseImageArn);

        /**
         * <p>
         * The display name for the image.
         * </p>
         * 
         * @param displayName
         *        The display name for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The image starts in the <b>PENDING</b> state, and then moves to <b>AVAILABLE</b> if image creation succeeds
         * and <b>FAILED</b> if image creation has failed.
         * </p>
         * 
         * @param state
         *        The image starts in the <b>PENDING</b> state, and then moves to <b>AVAILABLE</b> if image creation
         *        succeeds and <b>FAILED</b> if image creation has failed.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(String state);

        /**
         * <p>
         * The image starts in the <b>PENDING</b> state, and then moves to <b>AVAILABLE</b> if image creation succeeds
         * and <b>FAILED</b> if image creation has failed.
         * </p>
         * 
         * @param state
         *        The image starts in the <b>PENDING</b> state, and then moves to <b>AVAILABLE</b> if image creation
         *        succeeds and <b>FAILED</b> if image creation has failed.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(ImageState state);

        /**
         * <p>
         * The visibility of an image to the user; images can be public or private.
         * </p>
         * 
         * @param visibility
         *        The visibility of an image to the user; images can be public or private.
         * @see VisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityType
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of an image to the user; images can be public or private.
         * </p>
         * 
         * @param visibility
         *        The visibility of an image to the user; images can be public or private.
         * @see VisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityType
         */
        Builder visibility(VisibilityType visibility);

        /**
         * <p>
         * Whether an image builder can be launched from this image.
         * </p>
         * 
         * @param imageBuilderSupported
         *        Whether an image builder can be launched from this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilderSupported(Boolean imageBuilderSupported);

        /**
         * <p>
         * The operating system platform of the image.
         * </p>
         * 
         * @param platform
         *        The operating system platform of the image.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(String platform);

        /**
         * <p>
         * The operating system platform of the image.
         * </p>
         * 
         * @param platform
         *        The operating system platform of the image.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(PlatformType platform);

        /**
         * <p>
         * A meaningful description for the image.
         * </p>
         * 
         * @param description
         *        A meaningful description for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The reason why the last state change occurred.
         * </p>
         * 
         * @param stateChangeReason
         *        The reason why the last state change occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(ImageStateChangeReason stateChangeReason);

        /**
         * <p>
         * The applications associated with an image.
         * </p>
         * 
         * @param applications
         *        The applications associated with an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<Application> applications);

        /**
         * <p>
         * The applications associated with an image.
         * </p>
         * 
         * @param applications
         *        The applications associated with an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Application... applications);

        /**
         * <p>
         * The timestamp when the image was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The AWS release date of the public base image. For private images, this date is the release date of the base
         * image from which the image was created.
         * </p>
         * 
         * @param publicBaseImageReleasedDate
         *        The AWS release date of the public base image. For private images, this date is the release date of
         *        the base image from which the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicBaseImageReleasedDate(Instant publicBaseImageReleasedDate);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String baseImageArn;

        private String displayName;

        private String state;

        private String visibility;

        private Boolean imageBuilderSupported;

        private String platform;

        private String description;

        private ImageStateChangeReason stateChangeReason;

        private List<Application> applications;

        private Instant createdTime;

        private Instant publicBaseImageReleasedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            setName(model.name);
            setArn(model.arn);
            setBaseImageArn(model.baseImageArn);
            setDisplayName(model.displayName);
            setState(model.state);
            setVisibility(model.visibility);
            setImageBuilderSupported(model.imageBuilderSupported);
            setPlatform(model.platform);
            setDescription(model.description);
            setStateChangeReason(model.stateChangeReason);
            setApplications(model.applications);
            setCreatedTime(model.createdTime);
            setPublicBaseImageReleasedDate(model.publicBaseImageReleasedDate);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getBaseImageArn() {
            return baseImageArn;
        }

        @Override
        public final Builder baseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
            return this;
        }

        public final void setBaseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(ImageState state) {
            this.state(state.toString());
        }

        public final String getVisibility() {
            return visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(VisibilityType visibility) {
            this.visibility(visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final void setVisibility(VisibilityType visibility) {
            this.visibility(visibility.toString());
        }

        public final Boolean getImageBuilderSupported() {
            return imageBuilderSupported;
        }

        @Override
        public final Builder imageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
            return this;
        }

        public final void setImageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(PlatformType platform) {
            this.platform(platform.toString());
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ImageStateChangeReason getStateChangeReason() {
            return stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(ImageStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ImageStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        public final Collection<Application> getApplications() {
            return applications;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
        }

        @SafeVarargs
        public final void setApplications(Application... applications) {
            applications(Arrays.asList(applications));
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getPublicBaseImageReleasedDate() {
            return publicBaseImageReleasedDate;
        }

        @Override
        public final Builder publicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
            return this;
        }

        public final void setPublicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
        }

        @Override
        public Image build() {
            return new Image(this);
        }
    }
}
