/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateStackRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateStackRequest.Builder, UpdateStackRequest> {
    private final String displayName;

    private final String description;

    private final String name;

    private final List<StorageConnector> storageConnectors;

    private final Boolean deleteStorageConnectors;

    private UpdateStackRequest(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.name = builder.name;
        this.storageConnectors = builder.storageConnectors;
        this.deleteStorageConnectors = builder.deleteStorageConnectors;
    }

    /**
     * <p>
     * The name displayed to end users on the AppStream 2.0 portal.
     * </p>
     * 
     * @return The name displayed to end users on the AppStream 2.0 portal.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description displayed to end users on the AppStream 2.0 portal.
     * </p>
     * 
     * @return The description displayed to end users on the AppStream 2.0 portal.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the stack to update.
     * </p>
     * 
     * @return The name of the stack to update.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The storage connectors to be enabled for the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The storage connectors to be enabled for the stack.
     */
    public List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * Remove all the storage connectors currently enabled for the stack.
     * </p>
     * 
     * @return Remove all the storage connectors currently enabled for the stack.
     */
    public Boolean deleteStorageConnectors() {
        return deleteStorageConnectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((displayName() == null) ? 0 : displayName().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((storageConnectors() == null) ? 0 : storageConnectors().hashCode());
        hashCode = 31 * hashCode + ((deleteStorageConnectors() == null) ? 0 : deleteStorageConnectors().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest) obj;
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.storageConnectors() == null ^ this.storageConnectors() == null) {
            return false;
        }
        if (other.storageConnectors() != null && !other.storageConnectors().equals(this.storageConnectors())) {
            return false;
        }
        if (other.deleteStorageConnectors() == null ^ this.deleteStorageConnectors() == null) {
            return false;
        }
        if (other.deleteStorageConnectors() != null && !other.deleteStorageConnectors().equals(this.deleteStorageConnectors())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (storageConnectors() != null) {
            sb.append("StorageConnectors: ").append(storageConnectors()).append(",");
        }
        if (deleteStorageConnectors() != null) {
            sb.append("DeleteStorageConnectors: ").append(deleteStorageConnectors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateStackRequest> {
        /**
         * <p>
         * The name displayed to end users on the AppStream 2.0 portal.
         * </p>
         * 
         * @param displayName
         *        The name displayed to end users on the AppStream 2.0 portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description displayed to end users on the AppStream 2.0 portal.
         * </p>
         * 
         * @param description
         *        The description displayed to end users on the AppStream 2.0 portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the stack to update.
         * </p>
         * 
         * @param name
         *        The name of the stack to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The storage connectors to be enabled for the stack.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to be enabled for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to be enabled for the stack.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to be enabled for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * Remove all the storage connectors currently enabled for the stack.
         * </p>
         * 
         * @param deleteStorageConnectors
         *        Remove all the storage connectors currently enabled for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteStorageConnectors(Boolean deleteStorageConnectors);
    }

    private static final class BuilderImpl implements Builder {
        private String displayName;

        private String description;

        private String name;

        private List<StorageConnector> storageConnectors;

        private Boolean deleteStorageConnectors;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            setDisplayName(model.displayName);
            setDescription(model.description);
            setName(model.name);
            setStorageConnectors(model.storageConnectors);
            setDeleteStorageConnectors(model.deleteStorageConnectors);
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<StorageConnector> getStorageConnectors() {
            return storageConnectors;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
        }

        @SafeVarargs
        public final void setStorageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
        }

        public final Boolean getDeleteStorageConnectors() {
            return deleteStorageConnectors;
        }

        @Override
        public final Builder deleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
            return this;
        }

        public final void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }
}
