/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.appstream.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Fleet JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class FleetUnmarshaller implements Unmarshaller<Fleet, JsonUnmarshallerContext> {

    public Fleet unmarshall(JsonUnmarshallerContext context) throws Exception {
        Fleet.Builder fleetBuilder = Fleet.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.displayName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ImageName", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.imageName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.instanceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ComputeCapacityStatus", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.computeCapacityStatus(ComputeCapacityStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MaxUserDurationInSeconds", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.maxUserDurationInSeconds(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("DisconnectTimeoutInSeconds", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.disconnectTimeoutInSeconds(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.state(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VpcConfig", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.vpcConfig(VpcConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.createdTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("FleetErrors", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.fleetErrors(new ListUnmarshaller<FleetError>(FleetErrorUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("EnableDefaultInternetAccess", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.enableDefaultInternetAccess(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return fleetBuilder.build();
    }

    private static FleetUnmarshaller INSTANCE;

    public static FleetUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new FleetUnmarshaller();
        return INSTANCE;
    }
}
