/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.config.AsyncClientConfiguration;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.appstream.model.AssociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.AssociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appstream.model.CreateFleetRequest;
import software.amazon.awssdk.services.appstream.model.CreateFleetResponse;
import software.amazon.awssdk.services.appstream.model.CreateStackRequest;
import software.amazon.awssdk.services.appstream.model.CreateStackResponse;
import software.amazon.awssdk.services.appstream.model.CreateStreamingURLRequest;
import software.amazon.awssdk.services.appstream.model.CreateStreamingURLResponse;
import software.amazon.awssdk.services.appstream.model.DeleteFleetRequest;
import software.amazon.awssdk.services.appstream.model.DeleteFleetResponse;
import software.amazon.awssdk.services.appstream.model.DeleteStackRequest;
import software.amazon.awssdk.services.appstream.model.DeleteStackResponse;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImagesRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagesResponse;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeStacksRequest;
import software.amazon.awssdk.services.appstream.model.DescribeStacksResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.ExpireSessionRequest;
import software.amazon.awssdk.services.appstream.model.ExpireSessionResponse;
import software.amazon.awssdk.services.appstream.model.IncompatibleImageException;
import software.amazon.awssdk.services.appstream.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.appstream.model.InvalidRoleException;
import software.amazon.awssdk.services.appstream.model.LimitExceededException;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksResponse;
import software.amazon.awssdk.services.appstream.model.OperationNotPermittedException;
import software.amazon.awssdk.services.appstream.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.appstream.model.ResourceInUseException;
import software.amazon.awssdk.services.appstream.model.ResourceNotAvailableException;
import software.amazon.awssdk.services.appstream.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appstream.model.StartFleetRequest;
import software.amazon.awssdk.services.appstream.model.StartFleetResponse;
import software.amazon.awssdk.services.appstream.model.StopFleetRequest;
import software.amazon.awssdk.services.appstream.model.StopFleetResponse;
import software.amazon.awssdk.services.appstream.model.UpdateFleetRequest;
import software.amazon.awssdk.services.appstream.model.UpdateFleetResponse;
import software.amazon.awssdk.services.appstream.model.UpdateStackRequest;
import software.amazon.awssdk.services.appstream.model.UpdateStackResponse;
import software.amazon.awssdk.services.appstream.transform.AssociateFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.AssociateFleetResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateFleetResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateStackRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateStackResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateStreamingURLRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateStreamingURLResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteFleetResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteStackRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteStackResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeFleetsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeFleetsResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeImagesResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeSessionsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeSessionsResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeStacksRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeStacksResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.DisassociateFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DisassociateFleetResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.ExpireSessionRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.ExpireSessionResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.ListAssociatedFleetsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.ListAssociatedFleetsResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.ListAssociatedStacksRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.ListAssociatedStacksResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.StartFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.StartFleetResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.StopFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.StopFleetResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateFleetResponseUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateStackRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateStackResponseUnmarshaller;

/**
 * Internal implementation of {@link AppStreamAsyncClient}.
 *
 * @see AppStreamAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAppStreamAsyncClient implements AppStreamAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultAppStreamAsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Associate a fleet to a stack.
     * </p>
     *
     * @param associateFleetRequest
     * @return A Java Future containing the result of the AssociateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.AssociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateFleetResponse> associateFleet(AssociateFleetRequest associateFleetRequest) {

        HttpResponseHandler<AssociateFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new AssociateFleetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AssociateFleetRequest, AssociateFleetResponse>()
                .withMarshaller(new AssociateFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(associateFleetRequest));
    }

    /**
     * <p>
     * Creates a new fleet.
     * </p>
     *
     * @param createFleetRequest
     *        Contains the parameters for the new fleet to create.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {

        HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateFleetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createFleetRequest));
    }

    /**
     * <p>
     * Create a new stack.
     * </p>
     *
     * @param createStackRequest
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStackResponse> createStack(CreateStackRequest createStackRequest) {

        HttpResponseHandler<CreateStackResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateStackResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateStackRequest, CreateStackResponse>()
                .withMarshaller(new CreateStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createStackRequest));
    }

    /**
     * <p>
     * Creates a URL to start an AppStream 2.0 streaming session for a user. By default, the URL is valid only for 1
     * minute from the time that it is generated.
     * </p>
     *
     * @param createStreamingURLRequest
     * @return A Java Future containing the result of the CreateStreamingURL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStreamingURLResponse> createStreamingURL(CreateStreamingURLRequest createStreamingURLRequest) {

        HttpResponseHandler<CreateStreamingURLResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateStreamingURLResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateStreamingURLRequest, CreateStreamingURLResponse>()
                .withMarshaller(new CreateStreamingURLRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createStreamingURLRequest));
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {

        HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteFleetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                .withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteFleetRequest));
    }

    /**
     * <p>
     * Deletes the stack. After this operation completes, the environment can no longer be activated, and any
     * reservations made for the stack are released.
     * </p>
     *
     * @param deleteStackRequest
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStackResponse> deleteStack(DeleteStackRequest deleteStackRequest) {

        HttpResponseHandler<DeleteStackResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteStackResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteStackRequest, DeleteStackResponse>()
                .withMarshaller(new DeleteStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteStackRequest));
    }

    /**
     * <p>
     * If fleet names are provided, this operation describes the specified fleets; otherwise, all the fleets in the
     * account are described.
     * </p>
     *
     * @param describeFleetsRequest
     * @return A Java Future containing the result of the DescribeFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetsResponse> describeFleets(DescribeFleetsRequest describeFleetsRequest) {

        HttpResponseHandler<DescribeFleetsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeFleetsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeFleetsRequest, DescribeFleetsResponse>()
                .withMarshaller(new DescribeFleetsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeFleetsRequest));
    }

    /**
     * <p>
     * Describes the images. If a list of names is not provided, all images in your account are returned. This operation
     * does not return a paginated result.
     * </p>
     *
     * @param describeImagesRequest
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImagesResponse> describeImages(DescribeImagesRequest describeImagesRequest) {

        HttpResponseHandler<DescribeImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeImagesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeImagesRequest, DescribeImagesResponse>()
                .withMarshaller(new DescribeImagesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeImagesRequest));
    }

    /**
     * <p>
     * Describes the streaming sessions for a stack and a fleet. If a user ID is provided, this operation returns
     * streaming sessions for only that user. Pass this value for the <code>nextToken</code> parameter in a subsequent
     * call to this operation to retrieve the next set of items. If an authentication type is not provided, the
     * operation defaults to users authenticated using a streaming URL.
     * </p>
     *
     * @param describeSessionsRequest
     * @return A Java Future containing the result of the DescribeSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSessionsResponse> describeSessions(DescribeSessionsRequest describeSessionsRequest) {

        HttpResponseHandler<DescribeSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeSessionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeSessionsRequest, DescribeSessionsResponse>()
                .withMarshaller(new DescribeSessionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeSessionsRequest));
    }

    /**
     * <p>
     * If stack names are not provided, this operation describes the specified stacks; otherwise, all stacks in the
     * account are described. Pass the <code>nextToken</code> value in a subsequent call to this operation to retrieve
     * the next set of items.
     * </p>
     *
     * @param describeStacksRequest
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStacksResponse> describeStacks(DescribeStacksRequest describeStacksRequest) {

        HttpResponseHandler<DescribeStacksResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeStacksResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeStacksRequest, DescribeStacksResponse>()
                .withMarshaller(new DescribeStacksRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeStacksRequest));
    }

    /**
     * <p>
     * Disassociates a fleet from a stack.
     * </p>
     *
     * @param disassociateFleetRequest
     * @return A Java Future containing the result of the DisassociateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DisassociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateFleetResponse> disassociateFleet(DisassociateFleetRequest disassociateFleetRequest) {

        HttpResponseHandler<DisassociateFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DisassociateFleetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DisassociateFleetRequest, DisassociateFleetResponse>()
                .withMarshaller(new DisassociateFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(disassociateFleetRequest));
    }

    /**
     * <p>
     * This operation immediately stops a streaming session.
     * </p>
     *
     * @param expireSessionRequest
     * @return A Java Future containing the result of the ExpireSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ExpireSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ExpireSessionResponse> expireSession(ExpireSessionRequest expireSessionRequest) {

        HttpResponseHandler<ExpireSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ExpireSessionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ExpireSessionRequest, ExpireSessionResponse>()
                .withMarshaller(new ExpireSessionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(expireSessionRequest));
    }

    /**
     * <p>
     * Lists all fleets associated with the stack.
     * </p>
     *
     * @param listAssociatedFleetsRequest
     * @return A Java Future containing the result of the ListAssociatedFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ListAssociatedFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssociatedFleetsResponse> listAssociatedFleets(
            ListAssociatedFleetsRequest listAssociatedFleetsRequest) {

        HttpResponseHandler<ListAssociatedFleetsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListAssociatedFleetsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListAssociatedFleetsRequest, ListAssociatedFleetsResponse>()
                .withMarshaller(new ListAssociatedFleetsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listAssociatedFleetsRequest));
    }

    /**
     * <p>
     * Lists all stacks to which the specified fleet is associated.
     * </p>
     *
     * @param listAssociatedStacksRequest
     * @return A Java Future containing the result of the ListAssociatedStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ListAssociatedStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssociatedStacksResponse> listAssociatedStacks(
            ListAssociatedStacksRequest listAssociatedStacksRequest) {

        HttpResponseHandler<ListAssociatedStacksResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListAssociatedStacksResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListAssociatedStacksRequest, ListAssociatedStacksResponse>()
                .withMarshaller(new ListAssociatedStacksRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listAssociatedStacksRequest));
    }

    /**
     * <p>
     * Starts a fleet.
     * </p>
     *
     * @param startFleetRequest
     * @return A Java Future containing the result of the StartFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StartFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartFleetResponse> startFleet(StartFleetRequest startFleetRequest) {

        HttpResponseHandler<StartFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StartFleetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StartFleetRequest, StartFleetResponse>()
                .withMarshaller(new StartFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startFleetRequest));
    }

    /**
     * <p>
     * Stops a fleet.
     * </p>
     *
     * @param stopFleetRequest
     * @return A Java Future containing the result of the StopFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StopFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopFleetResponse> stopFleet(StopFleetRequest stopFleetRequest) {

        HttpResponseHandler<StopFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StopFleetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StopFleetRequest, StopFleetResponse>()
                .withMarshaller(new StopFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopFleetRequest));
    }

    /**
     * <p>
     * Updates an existing fleet. All the attributes except the fleet name can be updated in the <b>STOPPED</b> state.
     * When a fleet is in the <b>RUNNING</b> state, only <code>DisplayName</code> and <code>ComputeCapacity</code> can
     * be updated. A fleet cannot be updated in a status of <b>STARTING</b> or <b>STOPPING</b>.
     * </p>
     *
     * @param updateFleetRequest
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.UpdateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFleetResponse> updateFleet(UpdateFleetRequest updateFleetRequest) {

        HttpResponseHandler<UpdateFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateFleetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateFleetRequest, UpdateFleetResponse>()
                .withMarshaller(new UpdateFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateFleetRequest));
    }

    /**
     * <p>
     * Updates the specified fields in the stack with the specified name.
     * </p>
     *
     * @param updateStackRequest
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStackResponse> updateStack(UpdateStackRequest updateStackRequest) {

        HttpResponseHandler<UpdateStackResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateStackResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateStackRequest, UpdateStackResponse>()
                .withMarshaller(new UpdateStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateStackRequest));
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata()
                .withProtocolVersion("1.1")
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(software.amazon.awssdk.services.appstream.model.AppStreamException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(
                                ConcurrentModificationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(
                                ResourceInUseException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(
                                ResourceNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IncompatibleImageException").withModeledClass(
                                IncompatibleImageException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRoleException").withModeledClass(
                                InvalidRoleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidParameterCombinationException").withModeledClass(
                                InvalidParameterCombinationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceNotAvailableException").withModeledClass(
                                ResourceNotAvailableException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedException").withModeledClass(
                                OperationNotPermittedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(
                                ResourceAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                LimitExceededException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
