/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSessionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeSessionsRequest.Builder, DescribeSessionsRequest> {
    private final String stackName;

    private final String fleetName;

    private final String userId;

    private final String nextToken;

    private final Integer limit;

    private final String authenticationType;

    private DescribeSessionsRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.userId = builder.userId;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.authenticationType = builder.authenticationType;
    }

    /**
     * <p>
     * The name of the stack for which to list sessions.
     * </p>
     * 
     * @return The name of the stack for which to list sessions.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name of the fleet for which to list sessions.
     * </p>
     * 
     * @return The name of the fleet for which to list sessions.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The user for whom to list sessions. Use null to describe all the sessions for the stack and fleet.
     * </p>
     * 
     * @return The user for whom to list sessions. Use null to describe all the sessions for the stack and fleet.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The size of each page of results. The default value is 20 and the maximum supported value is 50.
     * </p>
     * 
     * @return The size of each page of results. The default value is 20 and the maximum supported value is 50.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The authentication method of the user. It can be <code>API</code> for a user authenticated using a streaming URL,
     * or <code>SAML</code> for a SAML federated user. If an authentication type is not provided, the operation defaults
     * to users authenticated using a streaming URL.
     * </p>
     * 
     * @return The authentication method of the user. It can be <code>API</code> for a user authenticated using a
     *         streaming URL, or <code>SAML</code> for a SAML federated user. If an authentication type is not provided,
     *         the operation defaults to users authenticated using a streaming URL.
     * @see AuthenticationType
     */
    public String authenticationType() {
        return authenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((fleetName() == null) ? 0 : fleetName().hashCode());
        hashCode = 31 * hashCode + ((userId() == null) ? 0 : userId().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((authenticationType() == null) ? 0 : authenticationType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSessionsRequest)) {
            return false;
        }
        DescribeSessionsRequest other = (DescribeSessionsRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.fleetName() == null ^ this.fleetName() == null) {
            return false;
        }
        if (other.fleetName() != null && !other.fleetName().equals(this.fleetName())) {
            return false;
        }
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        if (other.userId() != null && !other.userId().equals(this.userId())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.authenticationType() == null ^ this.authenticationType() == null) {
            return false;
        }
        if (other.authenticationType() != null && !other.authenticationType().equals(this.authenticationType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (fleetName() != null) {
            sb.append("FleetName: ").append(fleetName()).append(",");
        }
        if (userId() != null) {
            sb.append("UserId: ").append(userId()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (authenticationType() != null) {
            sb.append("AuthenticationType: ").append(authenticationType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSessionsRequest> {
        /**
         * <p>
         * The name of the stack for which to list sessions.
         * </p>
         * 
         * @param stackName
         *        The name of the stack for which to list sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name of the fleet for which to list sessions.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet for which to list sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The user for whom to list sessions. Use null to describe all the sessions for the stack and fleet.
         * </p>
         * 
         * @param userId
         *        The user for whom to list sessions. Use null to describe all the sessions for the stack and fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The size of each page of results. The default value is 20 and the maximum supported value is 50.
         * </p>
         * 
         * @param limit
         *        The size of each page of results. The default value is 20 and the maximum supported value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The authentication method of the user. It can be <code>API</code> for a user authenticated using a streaming
         * URL, or <code>SAML</code> for a SAML federated user. If an authentication type is not provided, the operation
         * defaults to users authenticated using a streaming URL.
         * </p>
         * 
         * @param authenticationType
         *        The authentication method of the user. It can be <code>API</code> for a user authenticated using a
         *        streaming URL, or <code>SAML</code> for a SAML federated user. If an authentication type is not
         *        provided, the operation defaults to users authenticated using a streaming URL.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication method of the user. It can be <code>API</code> for a user authenticated using a streaming
         * URL, or <code>SAML</code> for a SAML federated user. If an authentication type is not provided, the operation
         * defaults to users authenticated using a streaming URL.
         * </p>
         * 
         * @param authenticationType
         *        The authentication method of the user. It can be <code>API</code> for a user authenticated using a
         *        streaming URL, or <code>SAML</code> for a SAML federated user. If an authentication type is not
         *        provided, the operation defaults to users authenticated using a streaming URL.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);
    }

    private static final class BuilderImpl implements Builder {
        private String stackName;

        private String fleetName;

        private String userId;

        private String nextToken;

        private Integer limit;

        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSessionsRequest model) {
            setStackName(model.stackName);
            setFleetName(model.fleetName);
            setUserId(model.userId);
            setNextToken(model.nextToken);
            setLimit(model.limit);
            setAuthenticationType(model.authenticationType);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public DescribeSessionsRequest build() {
            return new DescribeSessionsRequest(this);
        }
    }
}
