/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSessionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSessionsResponse.Builder, DescribeSessionsResponse> {
    private final List<Session> sessions;

    private final String nextToken;

    private DescribeSessionsResponse(BuilderImpl builder) {
        this.sessions = builder.sessions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of streaming sessions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of streaming sessions.
     */
    public List<Session> sessions() {
        return sessions;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sessions() == null) ? 0 : sessions().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSessionsResponse)) {
            return false;
        }
        DescribeSessionsResponse other = (DescribeSessionsResponse) obj;
        if (other.sessions() == null ^ this.sessions() == null) {
            return false;
        }
        if (other.sessions() != null && !other.sessions().equals(this.sessions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (sessions() != null) {
            sb.append("Sessions: ").append(sessions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSessionsResponse> {
        /**
         * <p>
         * The list of streaming sessions.
         * </p>
         * 
         * @param sessions
         *        The list of streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Collection<Session> sessions);

        /**
         * <p>
         * The list of streaming sessions.
         * </p>
         * 
         * @param sessions
         *        The list of streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Session... sessions);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Session> sessions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSessionsResponse model) {
            setSessions(model.sessions);
            setNextToken(model.nextToken);
        }

        public final Collection<Session> getSessions() {
            return sessions;
        }

        @Override
        public final Builder sessions(Collection<Session> sessions) {
            this.sessions = SessionListCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Session... sessions) {
            sessions(Arrays.asList(sessions));
            return this;
        }

        public final void setSessions(Collection<Session> sessions) {
            this.sessions = SessionListCopier.copy(sessions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSessionsResponse build() {
            return new DescribeSessionsResponse(this);
        }
    }
}
