/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from a successful operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListAssociatedStacksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListAssociatedStacksResponse.Builder, ListAssociatedStacksResponse> {
    private final List<String> names;

    private final String nextToken;

    private ListAssociatedStacksResponse(BuilderImpl builder) {
        this.names = builder.names;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of associated stacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of associated stacks.
     */
    public List<String> names() {
        return names;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((names() == null) ? 0 : names().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedStacksResponse)) {
            return false;
        }
        ListAssociatedStacksResponse other = (ListAssociatedStacksResponse) obj;
        if (other.names() == null ^ this.names() == null) {
            return false;
        }
        if (other.names() != null && !other.names().equals(this.names())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (names() != null) {
            sb.append("Names: ").append(names()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListAssociatedStacksResponse> {
        /**
         * <p>
         * The names of associated stacks.
         * </p>
         * 
         * @param names
         *        The names of associated stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * The names of associated stacks.
         * </p>
         * 
         * @param names
         *        The names of associated stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> names;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedStacksResponse model) {
            setNames(model.names);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = StringListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = StringListCopier.copy(names);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssociatedStacksResponse build() {
            return new ListAssociatedStacksResponse(this);
        }
    }
}
