/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.appstream.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Stack JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StackUnmarshaller implements Unmarshaller<Stack, JsonUnmarshallerContext> {

    public Stack unmarshall(JsonUnmarshallerContext context) throws Exception {
        Stack.Builder stackBuilder = Stack.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    stackBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    stackBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    stackBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    stackBuilder.displayName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    context.nextToken();
                    stackBuilder.createdTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("StorageConnectors", targetDepth)) {
                    context.nextToken();
                    stackBuilder.storageConnectors(new ListUnmarshaller<StorageConnector>(StorageConnectorUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("StackErrors", targetDepth)) {
                    context.nextToken();
                    stackBuilder.stackErrors(new ListUnmarshaller<StackError>(StackErrorUnmarshaller.getInstance())
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return stackBuilder.build();
    }

    private static final StackUnmarshaller INSTANCE = new StackUnmarshaller();

    public static StackUnmarshaller getInstance() {
        return INSTANCE;
    }
}
