/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamingURLResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateStreamingURLResponse.Builder, CreateStreamingURLResponse> {
    private final String streamingURL;

    private final Instant expires;

    private CreateStreamingURLResponse(BuilderImpl builder) {
        this.streamingURL = builder.streamingURL;
        this.expires = builder.expires;
    }

    /**
     * <p>
     * The URL to start the AppStream 2.0 streaming session.
     * </p>
     * 
     * @return The URL to start the AppStream 2.0 streaming session.
     */
    public String streamingURL() {
        return streamingURL;
    }

    /**
     * <p>
     * Elapsed seconds after the Unix epoch, at which time this URL expires.
     * </p>
     * 
     * @return Elapsed seconds after the Unix epoch, at which time this URL expires.
     */
    public Instant expires() {
        return expires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamingURL() == null) ? 0 : streamingURL().hashCode());
        hashCode = 31 * hashCode + ((expires() == null) ? 0 : expires().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingURLResponse)) {
            return false;
        }
        CreateStreamingURLResponse other = (CreateStreamingURLResponse) obj;
        if (other.streamingURL() == null ^ this.streamingURL() == null) {
            return false;
        }
        if (other.streamingURL() != null && !other.streamingURL().equals(this.streamingURL())) {
            return false;
        }
        if (other.expires() == null ^ this.expires() == null) {
            return false;
        }
        if (other.expires() != null && !other.expires().equals(this.expires())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streamingURL() != null) {
            sb.append("StreamingURL: ").append(streamingURL()).append(",");
        }
        if (expires() != null) {
            sb.append("Expires: ").append(expires()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingURL":
            return Optional.of(clazz.cast(streamingURL()));
        case "Expires":
            return Optional.of(clazz.cast(expires()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStreamingURLResponse> {
        /**
         * <p>
         * The URL to start the AppStream 2.0 streaming session.
         * </p>
         * 
         * @param streamingURL
         *        The URL to start the AppStream 2.0 streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingURL(String streamingURL);

        /**
         * <p>
         * Elapsed seconds after the Unix epoch, at which time this URL expires.
         * </p>
         * 
         * @param expires
         *        Elapsed seconds after the Unix epoch, at which time this URL expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expires(Instant expires);
    }

    static final class BuilderImpl implements Builder {
        private String streamingURL;

        private Instant expires;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingURLResponse model) {
            streamingURL(model.streamingURL);
            expires(model.expires);
        }

        public final String getStreamingURL() {
            return streamingURL;
        }

        @Override
        public final Builder streamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
            return this;
        }

        public final void setStreamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
        }

        public final Instant getExpires() {
            return expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        @Override
        public CreateStreamingURLResponse build() {
            return new CreateStreamingURLResponse(this);
        }
    }
}
