/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ImageStateChangeReasonMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reason why the last state change occurred.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImageStateChangeReason implements StructuredPojo,
        ToCopyableBuilder<ImageStateChangeReason.Builder, ImageStateChangeReason> {
    private final String code;

    private final String message;

    private ImageStateChangeReason(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The state change reason code of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ImageStateChangeReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeString}.
     * </p>
     * 
     * @return The state change reason code of the image.
     * @see ImageStateChangeReasonCode
     */
    public ImageStateChangeReasonCode code() {
        return ImageStateChangeReasonCode.fromValue(code);
    }

    /**
     * <p>
     * The state change reason code of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ImageStateChangeReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeString}.
     * </p>
     * 
     * @return The state change reason code of the image.
     * @see ImageStateChangeReasonCode
     */
    public String codeString() {
        return code;
    }

    /**
     * <p>
     * The state change reason message to the end user.
     * </p>
     * 
     * @return The state change reason message to the end user.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((codeString() == null) ? 0 : codeString().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageStateChangeReason)) {
            return false;
        }
        ImageStateChangeReason other = (ImageStateChangeReason) obj;
        if (other.codeString() == null ^ this.codeString() == null) {
            return false;
        }
        if (other.codeString() != null && !other.codeString().equals(this.codeString())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (codeString() != null) {
            sb.append("Code: ").append(codeString()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.of(clazz.cast(codeString()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageStateChangeReasonMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ImageStateChangeReason> {
        /**
         * <p>
         * The state change reason code of the image.
         * </p>
         * 
         * @param code
         *        The state change reason code of the image.
         * @see ImageStateChangeReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageStateChangeReasonCode
         */
        Builder code(String code);

        /**
         * <p>
         * The state change reason code of the image.
         * </p>
         * 
         * @param code
         *        The state change reason code of the image.
         * @see ImageStateChangeReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageStateChangeReasonCode
         */
        Builder code(ImageStateChangeReasonCode code);

        /**
         * <p>
         * The state change reason message to the end user.
         * </p>
         * 
         * @param message
         *        The state change reason message to the end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageStateChangeReason model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ImageStateChangeReasonCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public ImageStateChangeReason build() {
            return new ImageStateChangeReason(this);
        }
    }
}
