/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListAssociatedStacksRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListAssociatedStacksRequest.Builder, ListAssociatedStacksRequest> {
    private final String fleetName;

    private final String nextToken;

    private ListAssociatedStacksRequest(BuilderImpl builder) {
        this.fleetName = builder.fleetName;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the fleet whose associated stacks are listed.
     * </p>
     * 
     * @return The name of the fleet whose associated stacks are listed.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fleetName() == null) ? 0 : fleetName().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedStacksRequest)) {
            return false;
        }
        ListAssociatedStacksRequest other = (ListAssociatedStacksRequest) obj;
        if (other.fleetName() == null ^ this.fleetName() == null) {
            return false;
        }
        if (other.fleetName() != null && !other.fleetName().equals(this.fleetName())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fleetName() != null) {
            sb.append("FleetName: ").append(fleetName()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetName":
            return Optional.of(clazz.cast(fleetName()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListAssociatedStacksRequest> {
        /**
         * <p>
         * The name of the fleet whose associated stacks are listed.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet whose associated stacks are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private String fleetName;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedStacksRequest model) {
            fleetName(model.fleetName);
            nextToken(model.nextToken);
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssociatedStacksRequest build() {
            return new ListAssociatedStacksRequest(this);
        }
    }
}
