/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateFleetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateFleetRequest.Builder, UpdateFleetRequest> {
    private final String imageName;

    private final String name;

    private final String instanceType;

    private final ComputeCapacity computeCapacity;

    private final VpcConfig vpcConfig;

    private final Integer maxUserDurationInSeconds;

    private final Integer disconnectTimeoutInSeconds;

    private final Boolean deleteVpcConfig;

    private final String description;

    private final String displayName;

    private final Boolean enableDefaultInternetAccess;

    private final List<String> attributesToDelete;

    private UpdateFleetRequest(BuilderImpl builder) {
        this.imageName = builder.imageName;
        this.name = builder.name;
        this.instanceType = builder.instanceType;
        this.computeCapacity = builder.computeCapacity;
        this.vpcConfig = builder.vpcConfig;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.deleteVpcConfig = builder.deleteVpcConfig;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.attributesToDelete = builder.attributesToDelete;
    }

    /**
     * <p>
     * The image name from which a fleet is created.
     * </p>
     * 
     * @return The image name from which a fleet is created.
     */
    public String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The instance type of compute resources for the fleet. Fleet instances are launched from this instance type.
     * </p>
     * 
     * @return The instance type of compute resources for the fleet. Fleet instances are launched from this instance
     *         type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The parameters for the capacity allocated to the fleet.
     * </p>
     * 
     * @return The parameters for the capacity allocated to the fleet.
     */
    public ComputeCapacity computeCapacity() {
        return computeCapacity;
    }

    /**
     * <p>
     * The VPC configuration for the fleet.
     * </p>
     * 
     * @return The VPC configuration for the fleet.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The maximum time for which a streaming session can run. The input can be any numeric value in seconds between 600
     * and 57600.
     * </p>
     * 
     * @return The maximum time for which a streaming session can run. The input can be any numeric value in seconds
     *         between 600 and 57600.
     */
    public Integer maxUserDurationInSeconds() {
        return maxUserDurationInSeconds;
    }

    /**
     * <p>
     * The time after disconnection when a session is considered to have ended. If a user who got disconnected
     * reconnects within this timeout interval, the user is connected back to their previous session. The input can be
     * any numeric value in seconds between 60 and 57600.
     * </p>
     * 
     * @return The time after disconnection when a session is considered to have ended. If a user who got disconnected
     *         reconnects within this timeout interval, the user is connected back to their previous session. The input
     *         can be any numeric value in seconds between 60 and 57600.
     */
    public Integer disconnectTimeoutInSeconds() {
        return disconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * Delete the VPC association for the specified fleet.
     * </p>
     * 
     * @return Delete the VPC association for the specified fleet.
     */
    public Boolean deleteVpcConfig() {
        return deleteVpcConfig;
    }

    /**
     * <p>
     * The description displayed to end users on the AppStream 2.0 portal.
     * </p>
     * 
     * @return The description displayed to end users on the AppStream 2.0 portal.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name displayed to end users on the AppStream 2.0 portal.
     * </p>
     * 
     * @return The name displayed to end users on the AppStream 2.0 portal.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Enables or disables default Internet access for the fleet.
     * </p>
     * 
     * @return Enables or disables default Internet access for the fleet.
     */
    public Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * <p>
     * Fleet attributes to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Fleet attributes to be deleted.
     */
    public List<FleetAttribute> attributesToDelete() {
        return TypeConverter.convert(attributesToDelete, FleetAttribute::fromValue);
    }

    /**
     * <p>
     * Fleet attributes to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Fleet attributes to be deleted.
     */
    public List<String> attributesToDeleteStrings() {
        return attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((imageName() == null) ? 0 : imageName().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((computeCapacity() == null) ? 0 : computeCapacity().hashCode());
        hashCode = 31 * hashCode + ((vpcConfig() == null) ? 0 : vpcConfig().hashCode());
        hashCode = 31 * hashCode + ((maxUserDurationInSeconds() == null) ? 0 : maxUserDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + ((disconnectTimeoutInSeconds() == null) ? 0 : disconnectTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + ((deleteVpcConfig() == null) ? 0 : deleteVpcConfig().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((displayName() == null) ? 0 : displayName().hashCode());
        hashCode = 31 * hashCode + ((enableDefaultInternetAccess() == null) ? 0 : enableDefaultInternetAccess().hashCode());
        hashCode = 31 * hashCode + ((attributesToDeleteStrings() == null) ? 0 : attributesToDeleteStrings().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetRequest)) {
            return false;
        }
        UpdateFleetRequest other = (UpdateFleetRequest) obj;
        if (other.imageName() == null ^ this.imageName() == null) {
            return false;
        }
        if (other.imageName() != null && !other.imageName().equals(this.imageName())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.computeCapacity() == null ^ this.computeCapacity() == null) {
            return false;
        }
        if (other.computeCapacity() != null && !other.computeCapacity().equals(this.computeCapacity())) {
            return false;
        }
        if (other.vpcConfig() == null ^ this.vpcConfig() == null) {
            return false;
        }
        if (other.vpcConfig() != null && !other.vpcConfig().equals(this.vpcConfig())) {
            return false;
        }
        if (other.maxUserDurationInSeconds() == null ^ this.maxUserDurationInSeconds() == null) {
            return false;
        }
        if (other.maxUserDurationInSeconds() != null && !other.maxUserDurationInSeconds().equals(this.maxUserDurationInSeconds())) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() == null ^ this.disconnectTimeoutInSeconds() == null) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() != null
                && !other.disconnectTimeoutInSeconds().equals(this.disconnectTimeoutInSeconds())) {
            return false;
        }
        if (other.deleteVpcConfig() == null ^ this.deleteVpcConfig() == null) {
            return false;
        }
        if (other.deleteVpcConfig() != null && !other.deleteVpcConfig().equals(this.deleteVpcConfig())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.enableDefaultInternetAccess() == null ^ this.enableDefaultInternetAccess() == null) {
            return false;
        }
        if (other.enableDefaultInternetAccess() != null
                && !other.enableDefaultInternetAccess().equals(this.enableDefaultInternetAccess())) {
            return false;
        }
        if (other.attributesToDeleteStrings() == null ^ this.attributesToDeleteStrings() == null) {
            return false;
        }
        if (other.attributesToDeleteStrings() != null
                && !other.attributesToDeleteStrings().equals(this.attributesToDeleteStrings())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (imageName() != null) {
            sb.append("ImageName: ").append(imageName()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (computeCapacity() != null) {
            sb.append("ComputeCapacity: ").append(computeCapacity()).append(",");
        }
        if (vpcConfig() != null) {
            sb.append("VpcConfig: ").append(vpcConfig()).append(",");
        }
        if (maxUserDurationInSeconds() != null) {
            sb.append("MaxUserDurationInSeconds: ").append(maxUserDurationInSeconds()).append(",");
        }
        if (disconnectTimeoutInSeconds() != null) {
            sb.append("DisconnectTimeoutInSeconds: ").append(disconnectTimeoutInSeconds()).append(",");
        }
        if (deleteVpcConfig() != null) {
            sb.append("DeleteVpcConfig: ").append(deleteVpcConfig()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (enableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(enableDefaultInternetAccess()).append(",");
        }
        if (attributesToDeleteStrings() != null) {
            sb.append("AttributesToDelete: ").append(attributesToDeleteStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageName":
            return Optional.of(clazz.cast(imageName()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "ComputeCapacity":
            return Optional.of(clazz.cast(computeCapacity()));
        case "VpcConfig":
            return Optional.of(clazz.cast(vpcConfig()));
        case "MaxUserDurationInSeconds":
            return Optional.of(clazz.cast(maxUserDurationInSeconds()));
        case "DisconnectTimeoutInSeconds":
            return Optional.of(clazz.cast(disconnectTimeoutInSeconds()));
        case "DeleteVpcConfig":
            return Optional.of(clazz.cast(deleteVpcConfig()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DisplayName":
            return Optional.of(clazz.cast(displayName()));
        case "EnableDefaultInternetAccess":
            return Optional.of(clazz.cast(enableDefaultInternetAccess()));
        case "AttributesToDelete":
            return Optional.of(clazz.cast(attributesToDeleteStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateFleetRequest> {
        /**
         * <p>
         * The image name from which a fleet is created.
         * </p>
         * 
         * @param imageName
         *        The image name from which a fleet is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param name
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The instance type of compute resources for the fleet. Fleet instances are launched from this instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type of compute resources for the fleet. Fleet instances are launched from this instance
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The parameters for the capacity allocated to the fleet.
         * </p>
         * 
         * @param computeCapacity
         *        The parameters for the capacity allocated to the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeCapacity(ComputeCapacity computeCapacity);

        /**
         * <p>
         * The VPC configuration for the fleet.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The maximum time for which a streaming session can run. The input can be any numeric value in seconds between
         * 600 and 57600.
         * </p>
         * 
         * @param maxUserDurationInSeconds
         *        The maximum time for which a streaming session can run. The input can be any numeric value in seconds
         *        between 600 and 57600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds);

        /**
         * <p>
         * The time after disconnection when a session is considered to have ended. If a user who got disconnected
         * reconnects within this timeout interval, the user is connected back to their previous session. The input can
         * be any numeric value in seconds between 60 and 57600.
         * </p>
         * 
         * @param disconnectTimeoutInSeconds
         *        The time after disconnection when a session is considered to have ended. If a user who got
         *        disconnected reconnects within this timeout interval, the user is connected back to their previous
         *        session. The input can be any numeric value in seconds between 60 and 57600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds);

        /**
         * <p>
         * Delete the VPC association for the specified fleet.
         * </p>
         * 
         * @param deleteVpcConfig
         *        Delete the VPC association for the specified fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteVpcConfig(Boolean deleteVpcConfig);

        /**
         * <p>
         * The description displayed to end users on the AppStream 2.0 portal.
         * </p>
         * 
         * @param description
         *        The description displayed to end users on the AppStream 2.0 portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name displayed to end users on the AppStream 2.0 portal.
         * </p>
         * 
         * @param displayName
         *        The name displayed to end users on the AppStream 2.0 portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Enables or disables default Internet access for the fleet.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Enables or disables default Internet access for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * <p>
         * Fleet attributes to be deleted.
         * </p>
         * 
         * @param attributesToDelete
         *        Fleet attributes to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(Collection<String> attributesToDelete);

        /**
         * <p>
         * Fleet attributes to be deleted.
         * </p>
         * 
         * @param attributesToDelete
         *        Fleet attributes to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(String... attributesToDelete);
    }

    static final class BuilderImpl implements Builder {
        private String imageName;

        private String name;

        private String instanceType;

        private ComputeCapacity computeCapacity;

        private VpcConfig vpcConfig;

        private Integer maxUserDurationInSeconds;

        private Integer disconnectTimeoutInSeconds;

        private Boolean deleteVpcConfig;

        private String description;

        private String displayName;

        private Boolean enableDefaultInternetAccess;

        private List<String> attributesToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetRequest model) {
            imageName(model.imageName);
            name(model.name);
            instanceType(model.instanceType);
            computeCapacity(model.computeCapacity);
            vpcConfig(model.vpcConfig);
            maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            deleteVpcConfig(model.deleteVpcConfig);
            description(model.description);
            displayName(model.displayName);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            attributesToDelete(model.attributesToDelete);
        }

        public final String getImageName() {
            return imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final ComputeCapacity.Builder getComputeCapacity() {
            return computeCapacity != null ? computeCapacity.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacity(ComputeCapacity computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        public final void setComputeCapacity(ComputeCapacity.BuilderImpl computeCapacity) {
            this.computeCapacity = computeCapacity != null ? computeCapacity.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final Boolean getDeleteVpcConfig() {
            return deleteVpcConfig;
        }

        @Override
        public final Builder deleteVpcConfig(Boolean deleteVpcConfig) {
            this.deleteVpcConfig = deleteVpcConfig;
            return this;
        }

        public final void setDeleteVpcConfig(Boolean deleteVpcConfig) {
            this.deleteVpcConfig = deleteVpcConfig;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final Collection<String> getAttributesToDelete() {
            return attributesToDelete;
        }

        @Override
        public final Builder attributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = FleetAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(String... attributesToDelete) {
            attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = FleetAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public UpdateFleetRequest build() {
            return new UpdateFleetRequest(this);
        }
    }
}
