/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.appstream.model.ComputeCapacity;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFleetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFleetRequest> {
    private final String name;
    private final String imageName;
    private final String instanceType;
    private final ComputeCapacity computeCapacity;
    private final VpcConfig vpcConfig;
    private final Integer maxUserDurationInSeconds;
    private final Integer disconnectTimeoutInSeconds;
    private final String description;
    private final String displayName;
    private final Boolean enableDefaultInternetAccess;

    private CreateFleetRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.imageName = builder.imageName;
        this.instanceType = builder.instanceType;
        this.computeCapacity = builder.computeCapacity;
        this.vpcConfig = builder.vpcConfig;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
    }

    public String name() {
        return this.name;
    }

    public String imageName() {
        return this.imageName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public ComputeCapacity computeCapacity() {
        return this.computeCapacity;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Integer maxUserDurationInSeconds() {
        return this.maxUserDurationInSeconds;
    }

    public Integer disconnectTimeoutInSeconds() {
        return this.disconnectTimeoutInSeconds;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.imageName() == null ? 0 : this.imageName().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.computeCapacity() == null ? 0 : this.computeCapacity().hashCode());
        hashCode = 31 * hashCode + (this.vpcConfig() == null ? 0 : this.vpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.maxUserDurationInSeconds() == null ? 0 : this.maxUserDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.disconnectTimeoutInSeconds() == null ? 0 : this.disconnectTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.enableDefaultInternetAccess() == null ? 0 : this.enableDefaultInternetAccess().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.imageName() == null ^ this.imageName() == null) {
            return false;
        }
        if (other.imageName() != null && !other.imageName().equals(this.imageName())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.computeCapacity() == null ^ this.computeCapacity() == null) {
            return false;
        }
        if (other.computeCapacity() != null && !other.computeCapacity().equals(this.computeCapacity())) {
            return false;
        }
        if (other.vpcConfig() == null ^ this.vpcConfig() == null) {
            return false;
        }
        if (other.vpcConfig() != null && !other.vpcConfig().equals(this.vpcConfig())) {
            return false;
        }
        if (other.maxUserDurationInSeconds() == null ^ this.maxUserDurationInSeconds() == null) {
            return false;
        }
        if (other.maxUserDurationInSeconds() != null && !other.maxUserDurationInSeconds().equals(this.maxUserDurationInSeconds())) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() == null ^ this.disconnectTimeoutInSeconds() == null) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() != null && !other.disconnectTimeoutInSeconds().equals(this.disconnectTimeoutInSeconds())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.enableDefaultInternetAccess() == null ^ this.enableDefaultInternetAccess() == null) {
            return false;
        }
        return other.enableDefaultInternetAccess() == null || other.enableDefaultInternetAccess().equals(this.enableDefaultInternetAccess());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.imageName() != null) {
            sb.append("ImageName: ").append(this.imageName()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.computeCapacity() != null) {
            sb.append("ComputeCapacity: ").append(this.computeCapacity()).append(",");
        }
        if (this.vpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.vpcConfig()).append(",");
        }
        if (this.maxUserDurationInSeconds() != null) {
            sb.append("MaxUserDurationInSeconds: ").append(this.maxUserDurationInSeconds()).append(",");
        }
        if (this.disconnectTimeoutInSeconds() != null) {
            sb.append("DisconnectTimeoutInSeconds: ").append(this.disconnectTimeoutInSeconds()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.enableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(this.enableDefaultInternetAccess()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ImageName": {
                return Optional.of(clazz.cast(this.imageName()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "ComputeCapacity": {
                return Optional.of(clazz.cast(this.computeCapacity()));
            }
            case "VpcConfig": {
                return Optional.of(clazz.cast(this.vpcConfig()));
            }
            case "MaxUserDurationInSeconds": {
                return Optional.of(clazz.cast(this.maxUserDurationInSeconds()));
            }
            case "DisconnectTimeoutInSeconds": {
                return Optional.of(clazz.cast(this.disconnectTimeoutInSeconds()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.of(clazz.cast(this.enableDefaultInternetAccess()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String imageName;
        private String instanceType;
        private ComputeCapacity computeCapacity;
        private VpcConfig vpcConfig;
        private Integer maxUserDurationInSeconds;
        private Integer disconnectTimeoutInSeconds;
        private String description;
        private String displayName;
        private Boolean enableDefaultInternetAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            this.name(model.name);
            this.imageName(model.imageName);
            this.instanceType(model.instanceType);
            this.computeCapacity(model.computeCapacity);
            this.vpcConfig(model.vpcConfig);
            this.maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            this.disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            this.description(model.description);
            this.displayName(model.displayName);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final ComputeCapacity.Builder getComputeCapacity() {
            return this.computeCapacity != null ? this.computeCapacity.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacity(ComputeCapacity computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        public final void setComputeCapacity(ComputeCapacity.BuilderImpl computeCapacity) {
            this.computeCapacity = computeCapacity != null ? computeCapacity.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return this.maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return this.disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFleetRequest> {
        public Builder name(String var1);

        public Builder imageName(String var1);

        public Builder instanceType(String var1);

        public Builder computeCapacity(ComputeCapacity var1);

        public Builder vpcConfig(VpcConfig var1);

        public Builder maxUserDurationInSeconds(Integer var1);

        public Builder disconnectTimeoutInSeconds(Integer var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder enableDefaultInternetAccess(Boolean var1);
    }
}

