/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateStackRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateStackRequest> {
    private final String name;
    private final String description;
    private final String displayName;
    private final List<StorageConnector> storageConnectors;

    private CreateStackRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.storageConnectors = builder.storageConnectors;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.storageConnectors() == null ? 0 : this.storageConnectors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.storageConnectors() == null ^ this.storageConnectors() == null) {
            return false;
        }
        return other.storageConnectors() == null || other.storageConnectors().equals(this.storageConnectors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.storageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.storageConnectors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "StorageConnectors": {
                return Optional.of(clazz.cast(this.storageConnectors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String displayName;
        private List<StorageConnector> storageConnectors;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            this.name(model.name);
            this.description(model.description);
            this.displayName(model.displayName);
            this.storageConnectors(model.storageConnectors);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return this.storageConnectors != null ? (Collection)this.storageConnectors.stream().map(StorageConnector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateStackRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);
    }
}

