/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.FleetErrorCode;
import software.amazon.awssdk.services.appstream.transform.FleetErrorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FleetError
implements StructuredPojo,
ToCopyableBuilder<Builder, FleetError> {
    private final String errorCode;
    private final String errorMessage;

    private FleetError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public FleetErrorCode errorCode() {
        return FleetErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeString() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.errorCodeString() == null ? 0 : this.errorCodeString().hashCode());
        hashCode = 31 * hashCode + (this.errorMessage() == null ? 0 : this.errorMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetError)) {
            return false;
        }
        FleetError other = (FleetError)obj;
        if (other.errorCodeString() == null ^ this.errorCodeString() == null) {
            return false;
        }
        if (other.errorCodeString() != null && !other.errorCodeString().equals(this.errorCodeString())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        return other.errorMessage() == null || other.errorMessage().equals(this.errorMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.errorCodeString() != null) {
            sb.append("ErrorCode: ").append(this.errorCodeString()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.of(clazz.cast(this.errorCodeString()));
            }
            case "ErrorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetError model) {
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(FleetErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public FleetError build() {
            return new FleetError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FleetError> {
        public Builder errorCode(String var1);

        public Builder errorCode(FleetErrorCode var1);

        public Builder errorMessage(String var1);
    }
}

