/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDirectoryConfigRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDirectoryConfigRequest.Builder, CreateDirectoryConfigRequest> {
    private final String directoryName;

    private final List<String> organizationalUnitDistinguishedNames;

    private final ServiceAccountCredentials serviceAccountCredentials;

    private CreateDirectoryConfigRequest(BuilderImpl builder) {
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedNames = builder.organizationalUnitDistinguishedNames;
        this.serviceAccountCredentials = builder.serviceAccountCredentials;
    }

    /**
     * <p>
     * The fully qualified name of the directory (for example, corp.example.com).
     * </p>
     * 
     * @return The fully qualified name of the directory (for example, corp.example.com).
     */
    public String directoryName() {
        return directoryName;
    }

    /**
     * <p>
     * The distinguished names of the organizational units for computer accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The distinguished names of the organizational units for computer accounts.
     */
    public List<String> organizationalUnitDistinguishedNames() {
        return organizationalUnitDistinguishedNames;
    }

    /**
     * <p>
     * The credentials for the service account used by the streaming instance to connect to the directory.
     * </p>
     * 
     * @return The credentials for the service account used by the streaming instance to connect to the directory.
     */
    public ServiceAccountCredentials serviceAccountCredentials() {
        return serviceAccountCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitDistinguishedNames());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountCredentials());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryConfigRequest)) {
            return false;
        }
        CreateDirectoryConfigRequest other = (CreateDirectoryConfigRequest) obj;
        return Objects.equals(directoryName(), other.directoryName())
                && Objects.equals(organizationalUnitDistinguishedNames(), other.organizationalUnitDistinguishedNames())
                && Objects.equals(serviceAccountCredentials(), other.serviceAccountCredentials());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (directoryName() != null) {
            sb.append("DirectoryName: ").append(directoryName()).append(",");
        }
        if (organizationalUnitDistinguishedNames() != null) {
            sb.append("OrganizationalUnitDistinguishedNames: ").append(organizationalUnitDistinguishedNames()).append(",");
        }
        if (serviceAccountCredentials() != null) {
            sb.append("ServiceAccountCredentials: ").append(serviceAccountCredentials()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryName":
            return Optional.of(clazz.cast(directoryName()));
        case "OrganizationalUnitDistinguishedNames":
            return Optional.of(clazz.cast(organizationalUnitDistinguishedNames()));
        case "ServiceAccountCredentials":
            return Optional.of(clazz.cast(serviceAccountCredentials()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDirectoryConfigRequest> {
        /**
         * <p>
         * The fully qualified name of the directory (for example, corp.example.com).
         * </p>
         * 
         * @param directoryName
         *        The fully qualified name of the directory (for example, corp.example.com).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(String directoryName);

        /**
         * <p>
         * The distinguished names of the organizational units for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedNames
         *        The distinguished names of the organizational units for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames);

        /**
         * <p>
         * The distinguished names of the organizational units for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedNames
         *        The distinguished names of the organizational units for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedNames(String... organizationalUnitDistinguishedNames);

        /**
         * <p>
         * The credentials for the service account used by the streaming instance to connect to the directory.
         * </p>
         * 
         * @param serviceAccountCredentials
         *        The credentials for the service account used by the streaming instance to connect to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials);

        /**
         * <p>
         * The credentials for the service account used by the streaming instance to connect to the directory.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceAccountCredentials.Builder} avoiding the
         * need to create one manually via {@link ServiceAccountCredentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceAccountCredentials.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceAccountCredentials(ServiceAccountCredentials)}.
         * 
         * @param serviceAccountCredentials
         *        a consumer that will call methods on {@link ServiceAccountCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAccountCredentials(ServiceAccountCredentials)
         */
        default Builder serviceAccountCredentials(Consumer<ServiceAccountCredentials.Builder> serviceAccountCredentials) {
            return serviceAccountCredentials(ServiceAccountCredentials.builder().apply(serviceAccountCredentials).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String directoryName;

        private List<String> organizationalUnitDistinguishedNames;

        private ServiceAccountCredentials serviceAccountCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryConfigRequest model) {
            directoryName(model.directoryName);
            organizationalUnitDistinguishedNames(model.organizationalUnitDistinguishedNames);
            serviceAccountCredentials(model.serviceAccountCredentials);
        }

        public final String getDirectoryName() {
            return directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final Collection<String> getOrganizationalUnitDistinguishedNames() {
            return organizationalUnitDistinguishedNames;
        }

        @Override
        public final Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier
                    .copy(organizationalUnitDistinguishedNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitDistinguishedNames(String... organizationalUnitDistinguishedNames) {
            organizationalUnitDistinguishedNames(Arrays.asList(organizationalUnitDistinguishedNames));
            return this;
        }

        public final void setOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier
                    .copy(organizationalUnitDistinguishedNames);
        }

        public final ServiceAccountCredentials.Builder getServiceAccountCredentials() {
            return serviceAccountCredentials != null ? serviceAccountCredentials.toBuilder() : null;
        }

        @Override
        public final Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        public final void setServiceAccountCredentials(ServiceAccountCredentials.BuilderImpl serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials != null ? serviceAccountCredentials.build() : null;
        }

        @Override
        public CreateDirectoryConfigRequest build() {
            return new CreateDirectoryConfigRequest(this);
        }
    }
}
