/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDirectoryConfigResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDirectoryConfigResponse.Builder, CreateDirectoryConfigResponse> {
    private final DirectoryConfig directoryConfig;

    private CreateDirectoryConfigResponse(BuilderImpl builder) {
        this.directoryConfig = builder.directoryConfig;
    }

    /**
     * <p>
     * Information about the directory configuration.
     * </p>
     * 
     * @return Information about the directory configuration.
     */
    public DirectoryConfig directoryConfig() {
        return directoryConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryConfigResponse)) {
            return false;
        }
        CreateDirectoryConfigResponse other = (CreateDirectoryConfigResponse) obj;
        return Objects.equals(directoryConfig(), other.directoryConfig());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (directoryConfig() != null) {
            sb.append("DirectoryConfig: ").append(directoryConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryConfig":
            return Optional.of(clazz.cast(directoryConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDirectoryConfigResponse> {
        /**
         * <p>
         * Information about the directory configuration.
         * </p>
         * 
         * @param directoryConfig
         *        Information about the directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryConfig(DirectoryConfig directoryConfig);

        /**
         * <p>
         * Information about the directory configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DirectoryConfig.Builder} avoiding the need to
         * create one manually via {@link DirectoryConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DirectoryConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #directoryConfig(DirectoryConfig)}.
         * 
         * @param directoryConfig
         *        a consumer that will call methods on {@link DirectoryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directoryConfig(DirectoryConfig)
         */
        default Builder directoryConfig(Consumer<DirectoryConfig.Builder> directoryConfig) {
            return directoryConfig(DirectoryConfig.builder().apply(directoryConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DirectoryConfig directoryConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryConfigResponse model) {
            directoryConfig(model.directoryConfig);
        }

        public final DirectoryConfig.Builder getDirectoryConfig() {
            return directoryConfig != null ? directoryConfig.toBuilder() : null;
        }

        @Override
        public final Builder directoryConfig(DirectoryConfig directoryConfig) {
            this.directoryConfig = directoryConfig;
            return this;
        }

        public final void setDirectoryConfig(DirectoryConfig.BuilderImpl directoryConfig) {
            this.directoryConfig = directoryConfig != null ? directoryConfig.build() : null;
        }

        @Override
        public CreateDirectoryConfigResponse build() {
            return new CreateDirectoryConfigResponse(this);
        }
    }
}
