/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeImageBuildersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeImageBuildersResponse.Builder, DescribeImageBuildersResponse> {
    private final List<ImageBuilder> imageBuilders;

    private final String nextToken;

    private DescribeImageBuildersResponse(BuilderImpl builder) {
        this.imageBuilders = builder.imageBuilders;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the ImageBuilders property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ImageBuilders property for this object.
     */
    public List<ImageBuilder> imageBuilders() {
        return imageBuilders;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageBuilders());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageBuildersResponse)) {
            return false;
        }
        DescribeImageBuildersResponse other = (DescribeImageBuildersResponse) obj;
        return Objects.equals(imageBuilders(), other.imageBuilders()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (imageBuilders() != null) {
            sb.append("ImageBuilders: ").append(imageBuilders()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageBuilders":
            return Optional.of(clazz.cast(imageBuilders()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeImageBuildersResponse> {
        /**
         * Sets the value of the ImageBuilders property for this object.
         *
         * @param imageBuilders
         *        The new value for the ImageBuilders property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilders(Collection<ImageBuilder> imageBuilders);

        /**
         * Sets the value of the ImageBuilders property for this object.
         *
         * @param imageBuilders
         *        The new value for the ImageBuilders property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilders(ImageBuilder... imageBuilders);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ImageBuilder> imageBuilders;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageBuildersResponse model) {
            imageBuilders(model.imageBuilders);
            nextToken(model.nextToken);
        }

        public final Collection<ImageBuilder.Builder> getImageBuilders() {
            return imageBuilders != null ? imageBuilders.stream().map(ImageBuilder::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder imageBuilders(Collection<ImageBuilder> imageBuilders) {
            this.imageBuilders = ImageBuilderListCopier.copy(imageBuilders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageBuilders(ImageBuilder... imageBuilders) {
            imageBuilders(Arrays.asList(imageBuilders));
            return this;
        }

        public final void setImageBuilders(Collection<ImageBuilder.BuilderImpl> imageBuilders) {
            this.imageBuilders = ImageBuilderListCopier.copyFromBuilder(imageBuilders);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImageBuildersResponse build() {
            return new DescribeImageBuildersResponse(this);
        }
    }
}
